<?php
/**
 * Test Selenium-Verbindung
 */

require_once 'api/resy_selenium_driver.php';

echo "🔍 Selenium-Verbindung Test\n";
echo "==========================\n\n";

// Prüfe ob Selenium läuft
if (ResySeleniumDriver::isAvailable()) {
    echo "✅ Selenium ist verfügbar!\n\n";
    
    // Teste Login
    $driver = new ResySeleniumDriver('D.ULUDAG', 'Ikizler123!', '453');
    
    if ($driver->connect()) {
        echo "✅ Verbindung hergestellt\n";
        
        if ($driver->login()) {
            echo "✅ Login erfolgreich!\n";
            
            $html = $driver->loadWheelsets();
            if ($html) {
                echo "✅ Reifensätze geladen (" . strlen($html) . " Zeichen)\n";
            }
        }
        
        $driver->close();
    }
    
} else {
    echo "❌ Selenium ist NICHT verfügbar!\n";
    echo "\n⚠️ Bitte starten:\n";
    echo "   docker-compose up -d\n";
}

echo "\n✅ Test abgeschlossen!\n";

?>


