<?php
/**
 * Test Selenium API
 */

echo "<h1>🧪 Selenium API Test</h1>";
echo "<pre>";

try {
    echo "1. Teste Selenium-Verbindung...\n";
    $ch = curl_init('http://localhost:4444/status');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($status == 200) {
        echo "✅ Selenium läuft!\n\n";
    } else {
        echo "❌ Selenium nicht erreichbar (HTTP $status)\n\n";
        exit;
    }
    
    echo "2. Teste API-Endpoint...\n";
    $apiUrl = 'http://localhost/boxenstop/api/get_stored_wheelsets.php?autohaus_id=1';
    $ch = curl_init($apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 120);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    echo "HTTP Status: $httpCode\n\n";
    
    $data = json_decode($response, true);
    
    if ($data) {
        echo "✅ API Response erhalten:\n";
        echo "  - Success: " . ($data['success'] ? 'JA' : 'NEIN') . "\n";
        echo "  - Source: " . ($data['source'] ?? 'N/A') . "\n";
        echo "  - Fetched from RESY: " . ($data['fetched_from_resy'] ? 'JA' : 'NEIN') . "\n";
        echo "  - Count: " . ($data['count'] ?? 0) . "\n\n";
        
        if (isset($data['wheelsets']) && count($data['wheelsets']) > 0) {
            echo "✅ Reifensätze gefunden!\n";
            echo "\nErste 3:\n";
            foreach (array_slice($data['wheelsets'], 0, 3) as $i => $ws) {
                echo "  " . ($i+1) . ". Kennzeichen: " . ($ws['kennzeichen'] ?? 'N/A') . "\n";
            }
        } else {
            echo "⚠️ Keine Reifensätze gefunden\n";
            echo "  - Nutzt Fallback auf Datenbank\n";
            echo "  - Oder Selenium konnte nicht login\n\n";
            
            echo "=== Debug Info ===\n";
            echo "Response: " . substr($response, 0, 500) . "\n";
        }
    } else {
        echo "❌ Keine JSON-Response\n";
        echo "Response: " . substr($response, 0, 500) . "\n";
    }
    
    echo "\n\n=== PHP Error Log ===\n";
    $errorLog = @file_get_contents('php_errors.log');
    if ($errorLog) {
        echo substr($errorLog, -1000);
    }
    
} catch (Exception $e) {
    echo "❌ Fehler: " . $e->getMessage() . "\n";
}

echo "</pre>";

