<?php
/**
 * Test-Script für Puppeteer-Integration
 */

echo "<h1>🧪 RESY Puppeteer Test</h1>";
echo "<pre>";

// 1. Prüfe Node.js
echo "[1/5] Prüfe Node.js...\n";
$nodeVersion = shell_exec('node -v 2>&1');
if ($nodeVersion) {
    echo "✅ Node.js: " . trim($nodeVersion) . "\n";
} else {
    echo "❌ Node.js nicht gefunden!\n";
    exit;
}

// 2. Prüfe Puppeteer
echo "\n[2/5] Prüfe Puppeteer...\n";
$puppeteerCheck = shell_exec('npm list puppeteer 2>&1');
if (strpos($puppeteerCheck, 'puppeteer') !== false) {
    echo "✅ Puppeteer installiert\n";
} else {
    echo "❌ Puppeteer nicht gefunden!\n";
    exit;
}

// 3. Erstelle Test-Script
echo "\n[3/5] Erstelle Test-Script...\n";
$testJs = __DIR__ . '/temp/test_puppeteer_' . time() . '.js';

$jsContent = <<<'JS'
const puppeteer = require('puppeteer');

(async () => {
    console.log("🚀 Starte Puppeteer...");
    
    const browser = await puppeteer.launch({
        headless: 'new',
        args: ['--no-sandbox', '--disable-setuid-sandbox']
    });
    
    console.log("✅ Browser gestartet");
    
    const page = await browser.newPage();
    console.log("✅ Neue Seite erstellt");
    
    await browser.close();
    console.log("✅ Browser geschlossen");
    
    console.log(JSON.stringify({
        success: true,
        message: "Puppeteer funktioniert!"
    }));
})();

JS;

file_put_contents($testJs, $jsContent);
echo "✅ Test-Script erstellt: $testJs\n";

// 4. Führe Test aus
echo "\n[4/5] Führe Puppeteer-Test aus...\n";
$output = shell_exec("node \"$testJs\" 2>&1");
echo $output . "\n";

// 5. Lösche Test-Script
@unlink($testJs);
echo "\n[5/5] ✅ Test abgeschlossen!\n";

echo "\n<hr>\n";
echo "<h2>📝 Nächste Schritte:</h2>";
echo "<ol>";
echo "<li>Öffne: <a href='admin/import_resy_data.php'>admin/import_resy_data.php</a></li>";
echo "<li>Klicke auf 'Automatischer Import mit Puppeteer'</li>";
echo "<li>Oder lade manuell eine RESY-HTML-Datei hoch</li>";
echo "</ol>";

echo "</pre>";

