<?php
/**
 * Test: Direkte RESY-Integration
 */

set_time_limit(120);
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "🧪 TEST: Direkte RESY-Integration\n";
echo str_repeat("=", 50) . "\n\n";

require_once 'config/database.php';
require_once 'api/resy_selenium_simple.php';

$db = new Database();
$pdo = $db->getConnection();

// Lade Credentials
$stmt = $pdo->prepare("SELECT id, name, resy_username, resy_password FROM autohaus WHERE id = 1");
$stmt->execute();
$autohaus = $stmt->fetch(PDO::FETCH_ASSOC);

echo "📝 Autohaus: " . $autohaus['name'] . "\n";
echo "📝 Username: " . $autohaus['resy_username'] . "\n";
echo "📝 Password: " . (strlen($autohaus['resy_password']) > 0 ? '***' : 'FEHLT') . "\n\n";

// Teste Selenium
if (!ResySeleniumDriver::isAvailable()) {
    echo "❌ Selenium nicht verfügbar!\n";
    echo "→ Starte Docker: docker-compose up -d\n";
    exit(1);
}

echo "✅ Selenium läuft\n\n";

// Erstelle Driver
$dealerId = '453'; // B & E Volvo Kiel
$driver = new ResySeleniumDriver(
    $autohaus['resy_username'], 
    $autohaus['resy_password'], 
    $dealerId
);

echo "🔐 Teste Login...\n";
if ($driver->login()) {
    echo "✅ Login erfolgreich!\n\n";
    
    echo "📦 Lade Reifensätze...\n";
    $html = $driver->loadWheelsets();
    
    if ($html && strlen($html) > 1000) {
        echo "✅ HTML geladen (" . strlen($html) . " Zeichen)\n";
        
        // Speichere HTML
        file_put_contents('temp/resy_result.html', $html);
        echo "📄 HTML gespeichert in: temp/resy_result.html\n\n";
        
        // Versuche zu parsen
        echo "🔍 Versuche zu parsen...\n";
        // Hier würde das HTML-Parsing erfolgen
        echo "✅ HTML verfügbar zum Parsen\n";
    } else {
        echo "❌ HTML zu kurz oder leer\n";
    }
    
    $driver->close();
} else {
    echo "❌ Login fehlgeschlagen\n";
}

echo "\n" . str_repeat("=", 50) . "\n";
echo "✅ Test abgeschlossen!\n";

