<?php
/**
 * Detaillierter RESY API Test
 */

echo "🧪 Detaillierter RESY-API Test\n";
echo str_repeat("=", 50) . "\n\n";

// Test 1: Prüfe ob Selenium läuft
echo "[TEST 1] Prüfe Selenium-Status...\n";
$ch = curl_init('http://localhost:4444/wd/hub/status');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode === 200) {
    echo "✅ Selenium läuft (HTTP $httpCode)\n\n";
} else {
    echo "❌ Selenium nicht erreichbar (HTTP $httpCode)\n";
    echo "→ Starte Docker: docker-compose up -d\n\n";
}

// Test 2: Prüfe Datenbank
echo "[TEST 2] Prüfe Datenbank-Tabelle...\n";
require_once 'config/database.php';
try {
    $db = new Database();
    $pdo = $db->getConnection();
    
    // Prüfe ob Tabelle existiert
    $stmt = $pdo->query("SHOW TABLES LIKE 'stored_wheelsets'");
    if ($stmt->rowCount() > 0) {
        echo "✅ Tabelle 'stored_wheelsets' existiert\n";
        
        // Zähle Einträge
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM stored_wheelsets");
        $count = $stmt->fetch(PDO::FETCH_ASSOC)['count'];
        echo "📊 Anzahl Einträge: $count\n\n";
    } else {
        echo "❌ Tabelle 'stored_wheelsets' fehlt!\n";
        echo "→ Führe aus: php setup_stored_wheelsets_table.php\n\n";
    }
    
} catch (Exception $e) {
    echo "❌ Datenbank-Fehler: " . $e->getMessage() . "\n\n";
}

// Test 3: API-Aufruf
echo "[TEST 3] Teste API-Endpoint...\n";
$url = "http://localhost/boxenstop/api/get_stored_wheelsets.php?autohaus_id=1";
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Status: $httpCode\n";

if ($httpCode === 200) {
    $data = json_decode($response, true);
    if ($data) {
        echo "✅ API antwortet korrekt\n";
        echo "✅ Autohaus: " . ($data['autohaus'] ?? 'N/A') . "\n";
        echo "✅ Quelle: " . ($data['source'] ?? 'N/A') . "\n";
        echo "✅ Anzahl: " . ($data['count'] ?? 0) . " Reifensätze\n";
        echo "✅ RESY-Daten: " . (isset($data['fetched_from_resy']) && $data['fetched_from_resy'] ? 'JA' : 'NEIN') . "\n\n";
        
        // Zeige JSON-Response
        echo "[DEBUG] JSON-Response:\n";
        echo str_repeat("-", 50) . "\n";
        echo json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "\n";
    } else {
        echo "❌ JSON-Parse-Fehler\n";
        echo "Response: " . substr($response, 0, 200) . "...\n\n";
    }
} else {
    echo "❌ API nicht erreichbar (HTTP $httpCode)\n\n";
}

// Test 4: Prüfe Credentials
echo "[TEST 4] Prüfe RESY-Credentials...\n";
try {
    $stmt = $pdo->prepare("SELECT id, name, resy_username FROM autohaus WHERE id = 1");
    $stmt->execute();
    $autohaus = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($autohaus) {
        echo "✅ Autohaus gefunden: " . $autohaus['name'] . "\n";
        if ($autohaus['resy_username']) {
            echo "✅ RESY-Credentials vorhanden\n";
        } else {
            echo "⚠️ RESY-Credentials fehlen!\n";
        }
    }
} catch (Exception $e) {
    echo "❌ Fehler: " . $e->getMessage() . "\n";
}

echo "\n" . str_repeat("=", 50) . "\n";
echo "✅ Test abgeschlossen!\n";

