<?php
/**
 * Direkter Test für Puppeteer
 */

require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/api/resy_puppeteer.php';

echo "<h1>🧪 Puppeteer Direkt-Test</h1>";
echo "<pre>";

try {
    // Lade Autohaus
    $db = new Database();
    $pdo = $db->getConnection();
    
    $stmt = $pdo->prepare("SELECT id, name, resy_username, resy_password FROM autohaus WHERE id = 1");
    $stmt->execute();
    $autohaus = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "Autohaus: " . ($autohaus['name'] ?? 'NICHT GEFUNDEN') . "\n";
    echo "Username: " . ($autohaus['resy_username'] ?? 'KEINER') . "\n";
    echo "\n";
    
    if (!$autohaus || !$autohaus['resy_username']) {
        throw new Exception("Keine Credentials!");
    }
    
    // Mapping
    $mapping = [
        'B & E Volvo Kiel' => '453',
        'B & E Volvo Norderstedt' => '452',
        'B & E Volvo Glinde' => '454'
    ];
    $dealerId = $mapping[$autohaus['name']] ?? '453';
    
    echo "Dealer ID: $dealerId\n\n";
    echo "Starte Puppeteer...\n";
    echo str_repeat("=", 50) . "\n\n";
    
    // Puppeteer
    $driver = new ResyPuppeteerDriver(
        $autohaus['resy_username'],
        $autohaus['resy_password'],
        $dealerId
    );
    
    $wheelsets = $driver->loginAndFetch();
    
    echo "\n" . str_repeat("=", 50) . "\n";
    echo "Ergebnis:\n";
    echo "Gefundene Reifensätze: " . count($wheelsets) . "\n\n";
    
    if (count($wheelsets) > 0) {
        echo "Erste 3 Reifensätze:\n";
        foreach (array_slice($wheelsets, 0, 3) as $i => $ws) {
            echo "  " . ($i+1) . ". Kennzeichen: " . ($ws['kennzeichen'] ?? 'N/A') . "\n";
        }
    } else {
        echo "⚠️ KEINE REIFENSÄTZE GEFUNDEN!\n\n";
        echo "Mögliche Ursachen:\n";
        echo "- Login fehlgeschlagen\n";
        echo "- Seite hat sich geändert\n";
        echo "- Wartezeiten zu kurz\n";
        echo "- CSS-Selektoren falsch\n\n";
        echo "Prüfe error_log oder PHP-Error-Log!\n";
    }
    
    // Zeige letzte Error-Logs
    echo "\n\n=== Letzte PHP Errors ===\n";
    $errorLog = file_get_contents('php_errors.log');
    if ($errorLog) {
        echo substr($errorLog, -1000);
    } else {
        echo "Keine Errors gefunden.";
    }
    
} catch (Exception $e) {
    echo "❌ FEHLER: " . $e->getMessage() . "\n";
    echo "Stack Trace:\n" . $e->getTraceAsString() . "\n";
}

echo "</pre>";

