<?php
echo "🔍 Teste PHP -> Playwright -> PHP\n";
echo "================================\n\n";

// Simuliere den Aufruf wie in get_stored_wheelsets.php
$script = __DIR__ . '/resy_playwright.js';
$command = "node \"$script\" 2>&1";

echo "📝 Befehl: $command\n\n";

$output = shell_exec($command);

echo "📦 Output-Länge: " . strlen($output) . " Zeichen\n";
echo "📦 Erste 200 Zeichen:\n";
echo substr($output, 0, 200) . "...\n\n";

echo "📦 Letzte 200 Zeichen:\n";
echo substr($output, -200) . "\n\n";

// Parse JSON
$lines = explode("\n", $output);
foreach ($lines as $line) {
    if (strpos($line, '{"success":') !== false) {
        echo "✅ JSON gefunden!\n";
        echo $line . "\n\n";
        
        $result = json_decode($line, true);
        if ($result) {
            echo "✅ JSON geparst: " . count($result['wheelsets']) . " Reifensätze\n";
        } else {
            echo "❌ JSON konnte nicht geparst werden\n";
        }
        break;
    }
}

