<?php
/**
 * Test-Script für die verbesserte Image-Proxy-Funktionalität
 */

echo "<h1>Test der verbesserten Image-Proxy-Funktionalität</h1>\n";

// Test-Parameter
$testLgfotoId = '76337'; // Beispiel-LGFOTO_ID aus den Logs
$testAppointmentId = '89'; // Beispiel-Appointment-ID

echo "<h2>Test-Parameter:</h2>\n";
echo "<ul>\n";
echo "<li>LGFOTO_ID: $testLgfotoId</li>\n";
echo "<li>Appointment ID: $testAppointmentId</li>\n";
echo "</ul>\n";

// Test 1: Direkter API-Aufruf
echo "<h2>Test 1: Direkter Image-Proxy-Aufruf</h2>\n";
$imageProxyUrl = "http://localhost:8080/api/resy_image_proxy.php?lgfoto_id=$testLgfotoId&appointment_id=$testAppointmentId";
echo "<p>URL: <a href='$imageProxyUrl' target='_blank'>$imageProxyUrl</a></p>\n";

// Test 2: cURL-Test
echo "<h2>Test 2: cURL-Test der Image-Proxy-API</h2>\n";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $imageProxyUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HEADER, true);
curl_setopt($ch, CURLOPT_NOBODY, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$contentType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
$error = curl_error($ch);
curl_close($ch);

echo "<p><strong>HTTP Code:</strong> $httpCode</p>\n";
echo "<p><strong>Content-Type:</strong> $contentType</p>\n";
echo "<p><strong>Error:</strong> " . ($error ?: 'Keine') . "</p>\n";

if ($httpCode === 200) {
    if (strpos($contentType, 'image/') === 0) {
        echo "<p style='color: green;'><strong>✅ Erfolgreich!</strong> Bild wird korrekt als Bild zurückgegeben.</p>\n";
        echo "<img src='$imageProxyUrl' alt='Test-Bild' style='max-width: 300px; border: 1px solid #ccc;'>\n";
    } else {
        echo "<p style='color: orange;'><strong>⚠️ Warnung:</strong> Response ist nicht vom Typ 'image/' sondern '$contentType'</p>\n";
    }
} else {
    echo "<p style='color: red;'><strong>❌ Fehler:</strong> HTTP Code $httpCode</p>\n";
}

// Test 3: Log-Datei prüfen
echo "<h2>Test 3: Log-Datei prüfen</h2>\n";
$logFile = __DIR__ . '/logs/resy_image_proxy.log';
if (file_exists($logFile)) {
    $logContent = file_get_contents($logFile);
    $lines = explode("\n", $logContent);
    $recentLines = array_slice($lines, -20); // Letzte 20 Zeilen
    
    echo "<h3>Letzte 20 Log-Einträge:</h3>\n";
    echo "<pre style='background: #f5f5f5; padding: 10px; border: 1px solid #ddd;'>\n";
    foreach ($recentLines as $line) {
        if (!empty(trim($line))) {
            echo htmlspecialchars($line) . "\n";
        }
    }
    echo "</pre>\n";
} else {
    echo "<p style='color: red;'>Log-Datei nicht gefunden: $logFile</p>\n";
}

// Test 4: Cookie-Datei prüfen
echo "<h2>Test 4: Cookie-Datei prüfen</h2>\n";
$cookieFile = sys_get_temp_dir() . '/resy_cookies_breakthrough.txt';
if (file_exists($cookieFile)) {
    $cookieContent = file_get_contents($cookieFile);
    $fileSize = filesize($cookieFile);
    $hasPhpSessionId = strpos($cookieContent, 'PHPSESSID') !== false;
    $fileAge = time() - filemtime($cookieFile);
    
    echo "<p><strong>Cookie-Datei gefunden:</strong> $cookieFile</p>\n";
    echo "<p><strong>Dateigröße:</strong> $fileSize Bytes</p>\n";
    echo "<p><strong>Alter:</strong> $fileAge Sekunden</p>\n";
    echo "<p><strong>PHPSESSID vorhanden:</strong> " . ($hasPhpSessionId ? 'JA' : 'NEIN') . "</p>\n";
    
    if ($fileAge > 3600) {
        echo "<p style='color: orange;'><strong>⚠️ Warnung:</strong> Cookie-Datei ist älter als 1 Stunde</p>\n";
    }
    
    echo "<h3>Cookie-Inhalt (erste 500 Zeichen):</h3>\n";
    echo "<pre style='background: #f5f5f5; padding: 10px; border: 1px solid #ddd;'>\n";
    echo htmlspecialchars(substr($cookieContent, 0, 500)) . "\n";
    echo "</pre>\n";
} else {
    echo "<p style='color: red;'><strong>❌ Cookie-Datei nicht gefunden:</strong> $cookieFile</p>\n";
    echo "<p>Das bedeutet, dass noch keine RESY-Session erstellt wurde.</p>\n";
}

echo "<h2>Zusammenfassung</h2>\n";
echo "<p>Die Verbesserungen umfassen:</p>\n";
echo "<ul>\n";
echo "<li>✅ Verbesserte Session-Cookie-Validierung</li>\n";
echo "<li>✅ Cookie-Synchronisation zwischen APIs</li>\n";
echo "<li>✅ Bessere Fehlerbehandlung und Fallback-Mechanismen</li>\n";
echo "<li>✅ Detaillierteres Logging</li>\n";
echo "<li>✅ Automatische Session-Erneuerung</li>\n";
echo "</ul>\n";

echo "<p><strong>Nächste Schritte:</strong></p>\n";
echo "<ol>\n";
echo "<li>Führen Sie 'Reifen prüfen' in der appointments.php durch</li>\n";
echo "<li>Prüfen Sie die Log-Dateien auf Erfolg/Fehler</li>\n";
echo "<li>Testen Sie die Bildladung in der Benutzeroberfläche</li>\n";
echo "</ol>\n";
?>
