<?php
/**
 * Test der korrigierten API
 */

echo "=== TEST DER KORRIGIERTEN API ===\n";

// Simuliere einen API-Aufruf
$_POST = [
    'action' => 'breakthrough',
    'lgs_id' => '9877038'
];

echo "Teste korrigierte API mit LGS_ID: 9877038\n\n";

// Erfange alle Ausgaben
ob_start();

try {
    // Lade die korrigierte API
    require_once 'api/resy_data_extraction_breakthrough_corrected.php';
    
    // Die API sollte JSON ausgeben
    $output = ob_get_contents();
    ob_end_clean();
    
    echo "API-Ausgabe:\n";
    echo "Länge: " . strlen($output) . " Zeichen\n";
    echo "Erste 500 Zeichen:\n";
    echo substr($output, 0, 500) . "\n";
    
    // Prüfe ob es gültiges JSON ist
    $jsonData = json_decode($output, true);
    if (json_last_error() === JSON_ERROR_NONE) {
        echo "\n✅ Gültiges JSON erhalten!\n";
        echo "Erfolg: " . ($jsonData['success'] ? 'Ja' : 'Nein') . "\n";
        if (isset($jsonData['error'])) {
            echo "Fehler: " . $jsonData['error'] . "\n";
        }
        if (isset($jsonData['message'])) {
            echo "Nachricht: " . $jsonData['message'] . "\n";
        }
        if (isset($jsonData['search_method'])) {
            echo "Suchmethode: " . $jsonData['search_method'] . "\n";
        }
    } else {
        echo "\n❌ Ungültiges JSON - Fehler: " . json_last_error_msg() . "\n";
        
        // Prüfe ob es HTML ist
        if (strpos($output, '<br />') !== false || strpos($output, '<b>') !== false) {
            echo "⚠️ HTML-Ausgabe erkannt - wahrscheinlich PHP-Fehler\n";
        }
    }
    
} catch (Exception $e) {
    ob_end_clean();
    echo "❌ Exception gefangen: " . $e->getMessage() . "\n";
    echo "Datei: " . $e->getFile() . "\n";
    echo "Zeile: " . $e->getLine() . "\n";
}

echo "\n=== TEST ABGESCHLOSSEN ===\n";
?>
