@echo off
REM ============================================
REM RESY Auto-Import Scheduler Setup
REM Erstellt Windows Task Scheduler Aufgaben
REM ============================================

setlocal enabledelayedexpansion

set SCRIPT_PATH=%~dp0resy_auto_import.bat
set TASK_NAME=RESY_Auto_Import

echo ============================================
echo RESY Auto-Import Scheduler Setup
echo ============================================
echo.
echo Script-Pfad: %SCRIPT_PATH%
echo.
echo WICHTIG: Das Script lädt jetzt Credentials aus der Datenbank!
echo Stelle sicher, dass in der Tabelle 'autohaus' alle Daten vorhanden sind:
echo   - resy_username
echo   - resy_password
echo   - resy_dealer_id
echo.

REM Prüfe ob Script existiert
if not exist "%SCRIPT_PATH%" (
    echo [FEHLER] Script nicht gefunden: %SCRIPT_PATH%
    pause
    exit /b 1
)

REM Lösche alte Tasks falls vorhanden
echo [1/3] Lösche alte Tasks...
schtasks /delete /tn "%TASK_NAME%_09" /f >nul 2>&1
schtasks /delete /tn "%TASK_NAME%_12" /f >nul 2>&1
schtasks /delete /tn "%TASK_NAME%_15" /f >nul 2>&1
schtasks /delete /tn "%TASK_NAME%_17" /f >nul 2>&1
echo [OK] Alte Tasks gelöscht
echo.

REM Erstelle neue Tasks (4x täglich: 9:00, 12:00, 15:00, 17:00)
echo [2/3] Erstelle neue Tasks...
echo.

REM WICHTIG: Benötigt Administrator-Rechte!
REM Prüfe ob wir Admin-Rechte haben
net session >nul 2>&1
if !errorlevel! neq 0 (
    echo [WARNUNG] Keine Administrator-Rechte erkannt!
    echo [WARNUNG] Bitte Script als Administrator ausführen!
    echo.
)

REM Konvertiere Pfad zu kurzem Format (8.3) für bessere Kompatibilität
for %%I in ("%SCRIPT_PATH%") do set SHORT_PATH=%%~sI

REM Tasks zwischen 08:00 - 18:00
REM Task 1: 09:00
echo [INFO] Erstelle Task: 09:00 Uhr...
schtasks /create /tn "%TASK_NAME%_09" /tr "\"%SCRIPT_PATH%\"" /sc daily /st 09:00 /f /rl highest 2>&1
if !errorlevel! equ 0 (
    echo [OK] Task erstellt: 09:00 Uhr
) else (
    echo [FEHLER] Task konnte nicht erstellt werden: 09:00 Uhr
    schtasks /create /tn "%TASK_NAME%_09" /tr "\"%SCRIPT_PATH%\"" /sc daily /st 09:00 /f 2>&1 | findstr /V "^$"
)

REM Task 2: 12:00
echo [INFO] Erstelle Task: 12:00 Uhr...
schtasks /create /tn "%TASK_NAME%_12" /tr "\"%SCRIPT_PATH%\"" /sc daily /st 12:00 /f /rl highest 2>&1
if !errorlevel! equ 0 (
    echo [OK] Task erstellt: 12:00 Uhr
) else (
    echo [FEHLER] Task konnte nicht erstellt werden: 12:00 Uhr
    schtasks /create /tn "%TASK_NAME%_12" /tr "\"%SCRIPT_PATH%\"" /sc daily /st 12:00 /f 2>&1 | findstr /V "^$"
)

REM Task 3: 15:00
echo [INFO] Erstelle Task: 15:00 Uhr...
schtasks /create /tn "%TASK_NAME%_15" /tr "\"%SCRIPT_PATH%\"" /sc daily /st 15:00 /f /rl highest 2>&1
if !errorlevel! equ 0 (
    echo [OK] Task erstellt: 15:00 Uhr
) else (
    echo [FEHLER] Task konnte nicht erstellt werden: 15:00 Uhr
    schtasks /create /tn "%TASK_NAME%_15" /tr "\"%SCRIPT_PATH%\"" /sc daily /st 15:00 /f 2>&1 | findstr /V "^$"
)

REM Task 4: 17:00
echo [INFO] Erstelle Task: 17:00 Uhr...
schtasks /create /tn "%TASK_NAME%_17" /tr "\"%SCRIPT_PATH%\"" /sc daily /st 17:00 /f /rl highest 2>&1
if !errorlevel! equ 0 (
    echo [OK] Task erstellt: 17:00 Uhr
) else (
    echo [FEHLER] Task konnte nicht erstellt werden: 17:00 Uhr
    schtasks /create /tn "%TASK_NAME%_17" /tr "\"%SCRIPT_PATH%\"" /sc daily /st 17:00 /f 2>&1 | findstr /V "^$"
)
echo.

echo.
echo [3/3] Prüfe erstellte Tasks...
echo.

set TASK_COUNT=0

schtasks /query /tn "%TASK_NAME%_09" /fo list /v >nul 2>&1
if !errorlevel! equ 0 (
    echo [OK] Task gefunden: %TASK_NAME%_09
    schtasks /query /tn "%TASK_NAME%_09" /fo list /v | findstr /C:"Task Name" /C:"Next Run Time" /C:"Status"
    set /a TASK_COUNT+=1
    echo.
) else (
    echo [FEHLER] Task nicht gefunden: %TASK_NAME%_09
    echo.
)

schtasks /query /tn "%TASK_NAME%_12" /fo list /v >nul 2>&1
if !errorlevel! equ 0 (
    echo [OK] Task gefunden: %TASK_NAME%_12
    schtasks /query /tn "%TASK_NAME%_12" /fo list /v | findstr /C:"Task Name" /C:"Next Run Time" /C:"Status"
    set /a TASK_COUNT+=1
    echo.
) else (
    echo [FEHLER] Task nicht gefunden: %TASK_NAME%_12
    echo.
)

schtasks /query /tn "%TASK_NAME%_15" /fo list /v >nul 2>&1
if !errorlevel! equ 0 (
    echo [OK] Task gefunden: %TASK_NAME%_15
    schtasks /query /tn "%TASK_NAME%_15" /fo list /v | findstr /C:"Task Name" /C:"Next Run Time" /C:"Status"
    set /a TASK_COUNT+=1
    echo.
) else (
    echo [FEHLER] Task nicht gefunden: %TASK_NAME%_15
    echo.
)

schtasks /query /tn "%TASK_NAME%_17" /fo list /v >nul 2>&1
if !errorlevel! equ 0 (
    echo [OK] Task gefunden: %TASK_NAME%_17
    schtasks /query /tn "%TASK_NAME%_17" /fo list /v | findstr /C:"Task Name" /C:"Next Run Time" /C:"Status"
    set /a TASK_COUNT+=1
    echo.
) else (
    echo [FEHLER] Task nicht gefunden: %TASK_NAME%_17
    echo.
)

echo.

echo ============================================
echo Setup abgeschlossen!
echo.
if !TASK_COUNT! equ 4 (
    echo ✅ Alle 4 Tasks erfolgreich erstellt!
    echo.
    echo Tasks laufen täglich um:
    echo  - 09:00 Uhr
    echo  - 12:00 Uhr
    echo  - 15:00 Uhr
    echo  - 17:00 Uhr
) else (
    echo ⚠️  Nur !TASK_COUNT! von 4 Tasks erstellt!
    echo.
    echo PROBLEM: Tasks benötigen Administrator-Rechte!
    echo.
    echo LÖSUNG:
    echo  1. Rechtsklick auf setup_resy_scheduler.bat
    echo  2. "Als Administrator ausführen" wählen
    echo  3. Script erneut ausführen
    echo.
)
echo.
echo Zum manuellen Testen:
echo   resy_auto_import.bat
echo.
echo Zum Prüfen der Tasks:
echo   schtasks /query | findstr RESY
echo ============================================

pause

endlocal

