<?php
/**
 * RESY REST API Konfigurations-Script
 * Hilft bei der Einrichtung der RESY-Credentials für Autohäuser
 */

require_once 'config/database.php';

header('Content-Type: text/html; charset=utf-8');

$db = new Database();
$conn = $db->getConnection();

// Handle POST-Request
$message = '';
$messageType = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_autohaus'])) {
    $autohausId = intval($_POST['autohaus_id']);
    $username = trim($_POST['resy_username'] ?? '');
    $password = trim($_POST['resy_password'] ?? '');
    $customerNo = trim($_POST['resy_customer_no'] ?? '');
    
    if ($autohausId > 0 && !empty($username) && !empty($password)) {
        // Prüfe ob resy_customer_no Spalte existiert
        $stmt = $conn->query("SHOW COLUMNS FROM autohaus LIKE 'resy_customer_no'");
        $hasCustomerNo = $stmt->rowCount() > 0;
        
        if ($hasCustomerNo && !empty($customerNo)) {
            $stmt = $conn->prepare("
                UPDATE autohaus 
                SET resy_username = ?, resy_password = ?, resy_customer_no = ?
                WHERE id = ?
            ");
            $stmt->execute([$username, $password, $customerNo, $autohausId]);
        } else {
            $stmt = $conn->prepare("
                UPDATE autohaus 
                SET resy_username = ?, resy_password = ?
                WHERE id = ?
            ");
            $stmt->execute([$username, $password, $autohausId]);
            
            if (!empty($customerNo) && !$hasCustomerNo) {
                // Füge Spalte hinzu
                try {
                    $conn->exec("ALTER TABLE autohaus ADD COLUMN resy_customer_no VARCHAR(50) NULL AFTER resy_dealer_id");
                    $stmt = $conn->prepare("UPDATE autohaus SET resy_customer_no = ? WHERE id = ?");
                    $stmt->execute([$customerNo, $autohausId]);
                } catch (Exception $e) {
                    // Spalte existiert bereits oder Fehler
                }
            }
        }
        
        $message = "✅ Autohaus erfolgreich konfiguriert!";
        $messageType = 'success';
    } else {
        $message = "❌ Bitte füllen Sie alle Pflichtfelder aus!";
        $messageType = 'error';
    }
}

// Lade alle Autohäuser
$stmt = $conn->query("
    SELECT 
        id, 
        name, 
        resy_username, 
        resy_password, 
        resy_dealer_id,
        CASE 
            WHEN EXISTS (
                SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS 
                WHERE TABLE_SCHEMA = DATABASE() 
                AND TABLE_NAME = 'autohaus' 
                AND COLUMN_NAME = 'resy_customer_no'
            ) THEN (
                SELECT resy_customer_no FROM autohaus a2 WHERE a2.id = autohaus.id
            )
            ELSE NULL
        END as resy_customer_no
    FROM autohaus 
    ORDER BY name
");
$autohauser = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Prüfe ob resy_customer_no Spalte existiert
$stmt = $conn->query("SHOW COLUMNS FROM autohaus LIKE 'resy_customer_no'");
$hasCustomerNo = $stmt->rowCount() > 0;
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RESY REST API Konfiguration</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            min-height: 100vh;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            border-radius: 12px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            padding: 30px;
        }
        h1 {
            color: #333;
            margin-bottom: 10px;
            font-size: 2rem;
        }
        .subtitle {
            color: #666;
            margin-bottom: 30px;
            font-size: 0.95rem;
        }
        .message {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-weight: 500;
        }
        .message.success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .message.error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .autohaus-card {
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
            background: #f9f9f9;
        }
        .autohaus-card h3 {
            color: #333;
            margin-bottom: 15px;
            font-size: 1.3rem;
        }
        .form-group {
            margin-bottom: 15px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
            color: #555;
            font-weight: 500;
            font-size: 0.9rem;
        }
        .form-group input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 6px;
            font-size: 0.95rem;
            transition: border-color 0.3s;
        }
        .form-group input:focus {
            outline: none;
            border-color: #667eea;
        }
        .form-group small {
            display: block;
            margin-top: 5px;
            color: #888;
            font-size: 0.85rem;
        }
        .btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 12px 30px;
            border-radius: 6px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
        }
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        .status {
            display: inline-block;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: 600;
            margin-left: 10px;
        }
        .status.configured {
            background: #d4edda;
            color: #155724;
        }
        .status.not-configured {
            background: #fff3cd;
            color: #856404;
        }
        .info-box {
            background: #e7f3ff;
            border-left: 4px solid #2196F3;
            padding: 15px;
            border-radius: 4px;
            margin-bottom: 20px;
        }
        .info-box strong {
            color: #1976D2;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔧 RESY REST API Konfiguration</h1>
        <p class="subtitle">Konfiguriere RESY-Credentials für alle Autohäuser</p>
        
        <?php if ($message): ?>
            <div class="message <?php echo $messageType; ?>">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>
        
        <div class="info-box">
            <strong>ℹ️ Testdaten (aus RESY-SCHNITTSTELLE.md):</strong><br>
            Benutzername: <code>BUE1</code><br>
            Passwort: <code>resytest</code><br>
            Kundennummer: <code>201</code>
        </div>
        
        <?php foreach ($autohauser as $autohaus): ?>
            <div class="autohaus-card">
                <h3>
                    <?php echo htmlspecialchars($autohaus['name']); ?>
                    <?php if (!empty($autohaus['resy_username']) && !empty($autohaus['resy_password'])): ?>
                        <span class="status configured">✅ Konfiguriert</span>
                    <?php else: ?>
                        <span class="status not-configured">⚠️ Nicht konfiguriert</span>
                    <?php endif; ?>
                </h3>
                
                <form method="POST">
                    <input type="hidden" name="autohaus_id" value="<?php echo $autohaus['id']; ?>">
                    <input type="hidden" name="update_autohaus" value="1">
                    
                    <div class="form-group">
                        <label for="username_<?php echo $autohaus['id']; ?>">RESY Benutzername *</label>
                        <input 
                            type="text" 
                            id="username_<?php echo $autohaus['id']; ?>" 
                            name="resy_username" 
                            value="<?php echo htmlspecialchars($autohaus['resy_username'] ?? ''); ?>"
                            placeholder="z.B. BUE1"
                            required>
                    </div>
                    
                    <div class="form-group">
                        <label for="password_<?php echo $autohaus['id']; ?>">RESY Passwort *</label>
                        <input 
                            type="password" 
                            id="password_<?php echo $autohaus['id']; ?>" 
                            name="resy_password" 
                            value="<?php echo htmlspecialchars($autohaus['resy_password'] ?? ''); ?>"
                            placeholder="RESY Passwort eingeben"
                            required>
                        <small>Passwort wird als Klartext gespeichert (verschlüsselte Speicherung möglich)</small>
                    </div>
                    
                    <?php if ($hasCustomerNo): ?>
                        <div class="form-group">
                            <label for="customer_no_<?php echo $autohaus['id']; ?>">RESY Kundennummer</label>
                            <input 
                                type="text" 
                                id="customer_no_<?php echo $autohaus['id']; ?>" 
                                name="resy_customer_no" 
                                value="<?php echo htmlspecialchars($autohaus['resy_customer_no'] ?? ''); ?>"
                                placeholder="z.B. 201">
                            <small>Kundennummer für RESY REST API (optional, wird automatisch ermittelt wenn leer)</small>
                        </div>
                    <?php endif; ?>
                    
                    <button type="submit" class="btn">💾 Konfiguration speichern</button>
                </form>
            </div>
        <?php endforeach; ?>
        
        <div style="margin-top: 30px; padding-top: 20px; border-top: 2px solid #e0e0e0;">
            <h3>📋 Nächste Schritte:</h3>
            <ol style="margin-left: 20px; line-height: 2;">
                <li>Fülle die Credentials für jedes Autohaus aus</li>
                <li>Klicke auf "Konfiguration speichern"</li>
                <li>Teste die API: <a href="test_resy_rest_api.php" target="_blank">test_resy_rest_api.php</a></li>
                <li>Öffne die Storage-Seite: <a href="admin/storage.php" target="_blank">admin/storage.php</a></li>
            </ol>
        </div>
    </div>
</body>
</html>

