<?php
require_once __DIR__ . '/../config/database.php';

try {
    $database = new Database();
    $conn = $database->getConnection();
    
    if (!$conn) {
        throw new Exception("Keine Datenbankverbindung möglich");
    }
    
    // Create tire_suggestions table
    $sql = "CREATE TABLE IF NOT EXISTS `tire_suggestions` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `autohaus_id` int(11) NOT NULL,
        `brand_model` varchar(255) NOT NULL,
        `eu_label` varchar(50) DEFAULT NULL,
        `size_pattern` varchar(100) DEFAULT NULL,
        `usage_count` int(11) DEFAULT 1,
        `last_used` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
        `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
        PRIMARY KEY (`id`),
        KEY `idx_autohaus_id` (`autohaus_id`),
        KEY `idx_brand_model` (`brand_model`),
        KEY `idx_usage_count` (`usage_count`),
        KEY `idx_last_used` (`last_used`),
        CONSTRAINT `tire_suggestions_ibfk_1` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci";
    
    if ($conn->exec($sql) !== false) {
        echo "Tabelle tire_suggestions erfolgreich erstellt.\n";
    } else {
        throw new Exception("Fehler beim Erstellen der Tabelle");
    }
    
    // Insert some sample data
    $sampleData = [
        ['Continental EcoContact 6 Q', 'A B B 71', '245/45 R19'],
        ['Michelin Primacy 4', 'A A B 71', '225/55 R17'],
        ['Bridgestone Turanza T005', 'A B B 71', '235/45 R18'],
        ['Pirelli P Zero', 'A A B 71', '255/40 R20'],
        ['Goodyear EfficientGrip Performance', 'A B B 71', '215/60 R16'],
        ['Dunlop Sport Maxx RT2', 'A A B 71', '245/40 R19'],
        ['Hankook Ventus Prime3 K125', 'A B B 71', '225/50 R17'],
        ['Falken Azenis FK510', 'A B B 71', '235/45 R18']
    ];
    
    $stmt = $conn->prepare("
        INSERT INTO tire_suggestions (autohaus_id, brand_model, eu_label, size_pattern, usage_count) 
        VALUES (?, ?, ?, ?, ?)
        ON DUPLICATE KEY UPDATE 
        usage_count = usage_count + 1,
        last_used = CURRENT_TIMESTAMP
    ");
    
    foreach ($sampleData as $data) {
        $autohaus_id = 1; // Default autohaus
        $stmt->execute([$autohaus_id, $data[0], $data[1], $data[2], 1]);
    }
    
    echo "Beispieldaten erfolgreich eingefügt.\n";
    
} catch (Exception $e) {
    echo "Fehler: " . $e->getMessage() . "\n";
} finally {
    // PDO connection doesn't need explicit closing
}
?>
