<?php
/**
 * Erstellt die Bild-Cache-Tabelle
 */

require_once __DIR__ . '/../config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    $sql = "
    CREATE TABLE IF NOT EXISTS cached_images (
        id INT AUTO_INCREMENT PRIMARY KEY,
        lgfoto_id VARCHAR(50) NOT NULL,
        filename VARCHAR(255) NOT NULL,
        content_type VARCHAR(100) NOT NULL,
        appointment_id INT,
        file_size INT NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        INDEX idx_lgfoto_id (lgfoto_id),
        INDEX idx_appointment_id (appointment_id),
        INDEX idx_created_at (created_at)
    ) COMMENT = 'Cache für Reifenbilder aus RESY-System'
    ";
    
    $conn->exec($sql);
    echo "✅ Tabelle 'cached_images' erfolgreich erstellt!\n";
    
    // Prüfe ob Tabelle existiert
    $stmt = $conn->query("SHOW TABLES LIKE 'cached_images'");
    if ($stmt->rowCount() > 0) {
        echo "✅ Tabelle existiert und ist bereit für den Bild-Cache.\n";
    } else {
        echo "❌ Fehler: Tabelle wurde nicht erstellt.\n";
    }
    
} catch (Exception $e) {
    echo "❌ Fehler beim Erstellen der Tabelle: " . $e->getMessage() . "\n";
}
?>
