<?php
/**
 * RESY-System Reverse Engineering
 * Analysiert das aktualisierte RESY-System um die korrekte Suchlogik zu finden
 */

require_once 'api/resy_data_extraction_breakthrough.php';

echo "=== RESY SYSTEM REVERSE ENGINEERING ===\n";

$testConfig = [
    'base_url' => 'https://resy.dtm-reifen.de',
    'username' => 'D.ULUDAG',
    'password' => 'Ikizler123!',
    'test_lgs_id' => '9877038'
];

try {
    // Login durchführen
    echo "--- Login durchführen ---\n";
    performBreakthroughLogin($testConfig['base_url'], $testConfig['username'], $testConfig['password']);
    echo "✅ Login erfolgreich\n\n";
    
    // Teste verschiedene Such-URLs und Parameter
    echo "--- Teste verschiedene Such-URLs ---\n";
    
    $searchVariations = [
        // Originale URL-Struktur
        'original' => $testConfig['base_url'] . '/index.php?m=wheelset&a=search&LGS_ID=' . $testConfig['test_lgs_id'] . '&button=submit&FN=WheelsetSearch',
        
        // Ohne button Parameter
        'no_button' => $testConfig['base_url'] . '/index.php?m=wheelset&a=search&LGS_ID=' . $testConfig['test_lgs_id'] . '&FN=WheelsetSearch',
        
        // Ohne FN Parameter
        'no_fn' => $testConfig['base_url'] . '/index.php?m=wheelset&a=search&LGS_ID=' . $testConfig['test_lgs_id'] . '&button=submit',
        
        // Nur LGS_ID
        'only_lgs_id' => $testConfig['base_url'] . '/index.php?m=wheelset&a=search&LGS_ID=' . $testConfig['test_lgs_id'],
        
        // Mit anderen Parameternamen
        'alt_param_1' => $testConfig['base_url'] . '/index.php?m=wheelset&a=search&search_id=' . $testConfig['test_lgs_id'],
        'alt_param_2' => $testConfig['base_url'] . '/index.php?m=wheelset&a=search&id=' . $testConfig['test_lgs_id'],
        'alt_param_3' => $testConfig['base_url'] . '/index.php?m=wheelset&a=search&number=' . $testConfig['test_lgs_id'],
        
        // POST-basierte Suche
        'post_search' => $testConfig['base_url'] . '/index.php?m=wheelset&a=search',
        
        // Andere Module
        'module_search' => $testConfig['base_url'] . '/index.php?m=search&a=wheelset&LGS_ID=' . $testConfig['test_lgs_id'],
        'module_find' => $testConfig['base_url'] . '/index.php?m=find&a=wheelset&LGS_ID=' . $testConfig['test_lgs_id'],
        
        // Direkte Detailseite
        'direct_detail' => $testConfig['base_url'] . '/index.php?m=wheelset&a=edit&LGS_ID=' . $testConfig['test_lgs_id'],
        'direct_view' => $testConfig['base_url'] . '/index.php?m=wheelset&a=view&LGS_ID=' . $testConfig['test_lgs_id'],
    ];
    
    foreach ($searchVariations as $name => $url) {
        echo "Teste: $name\n";
        echo "URL: $url\n";
        
        try {
            $response = httpRequest($url, [
                'headers' => [
                    'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36',
                    'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8',
                    'Accept-Language: de-DE,de;q=0.9,en;q=0.8',
                    'Referer: ' . $testConfig['base_url']
                ]
            ]);
            
            echo "Response Code: " . $response['http_code'] . "\n";
            echo "Final URL: " . $response['final_url'] . "\n";
            echo "Content Length: " . strlen($response['body']) . " Zeichen\n";
            
            // Analysiere den Inhalt
            $hasLoginForm = strpos($response['body'], 'Anmeldename') !== false;
            $hasWheelsetData = strpos($response['body'], 'WheelHALTERNAME') !== false || 
                              strpos($response['body'], 'WheelKENNZEICHEN') !== false;
            $hasLgsId = strpos($response['body'], 'LGS_ID') !== false;
            $hasSearchForm = strpos($response['body'], 'search') !== false;
            
            echo "Enthält Login-Form: " . ($hasLoginForm ? 'Ja' : 'Nein') . "\n";
            echo "Enthält Wheelset-Daten: " . ($hasWheelsetData ? 'Ja' : 'Nein') . "\n";
            echo "Enthält LGS_ID: " . ($hasLgsId ? 'Ja' : 'Nein') . "\n";
            echo "Enthält Such-Form: " . ($hasSearchForm ? 'Ja' : 'Nein') . "\n";
            
            if ($hasWheelsetData) {
                echo "🎉 ERFOLG! Wheelset-Daten gefunden!\n";
                
                // Speichere die erfolgreiche Antwort
                file_put_contents(sys_get_temp_dir() . "/resy_success_$name.html", $response['body']);
                echo "Erfolgreiche Antwort gespeichert in: " . sys_get_temp_dir() . "/resy_success_$name.html\n";
                
                // Extrahiere LGS_ID aus der Antwort
                if (preg_match('/LGS_ID=(\d+)/', $response['body'], $matches)) {
                    echo "Gefundene LGS_ID: " . $matches[1] . "\n";
                }
                
                break; // Stoppe bei erstem Erfolg
            }
            
            echo "\n";
            
        } catch (Exception $e) {
            echo "❌ Fehler: " . $e->getMessage() . "\n\n";
        }
    }
    
    // Teste auch POST-basierte Suche
    echo "--- Teste POST-basierte Suche ---\n";
    try {
        $postUrl = $testConfig['base_url'] . '/index.php?m=wheelset&a=search';
        $postData = [
            'LGS_ID' => $testConfig['test_lgs_id'],
            'button' => 'submit',
            'FN' => 'WheelsetSearch'
        ];
        
        $response = httpRequest($postUrl, [
            'method' => 'POST',
            'data' => http_build_query($postData),
            'headers' => [
                'Content-Type: application/x-www-form-urlencoded',
                'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36',
                'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8',
                'Accept-Language: de-DE,de;q=0.9,en;q=0.8',
                'Referer: ' . $testConfig['base_url']
            ]
        ]);
        
        echo "POST Response Code: " . $response['http_code'] . "\n";
        echo "POST Final URL: " . $response['final_url'] . "\n";
        echo "POST Content Length: " . strlen($response['body']) . " Zeichen\n";
        
        $hasWheelsetData = strpos($response['body'], 'WheelHALTERNAME') !== false || 
                          strpos($response['body'], 'WheelKENNZEICHEN') !== false;
        
        if ($hasWheelsetData) {
            echo "🎉 POST-ERFOLG! Wheelset-Daten gefunden!\n";
            file_put_contents(sys_get_temp_dir() . "/resy_success_post.html", $response['body']);
        } else {
            echo "❌ POST-Suche ohne Wheelset-Daten\n";
        }
        
    } catch (Exception $e) {
        echo "❌ POST-Fehler: " . $e->getMessage() . "\n";
    }
    
} catch (Exception $e) {
    echo "❌ Test fehlgeschlagen: " . $e->getMessage() . "\n";
}

echo "\n=== REVERSE ENGINEERING ABGESCHLOSSEN ===\n";
?>
