const { chromium } = require('playwright');

async function fetchWheelsets() {
    console.log('🚀 Starte RESY-Import mit Playwright...\n');
    
    const browser = await chromium.launch({
        headless: false,
        channel: 'chrome'
    });
    
    const page = await browser.newPage();
    
    try {
        console.log('[1/5] Navigiere zur Login-Seite...');
        await page.goto('https://resy.dtm-reifen.de/index.php?m=login&a=login', {
            waitUntil: 'networkidle'
        });
        
        console.log('[2/5] Fülle Login-Felder...');
        await page.fill('#InputUser', 'D.ULUDAG');
        await page.fill('#InputPass', 'Ikizler123!');
        
        console.log('[3/5] Klicke Login-Button...');
        await page.click('button[type="submit"]');
        await page.waitForTimeout(8000);
        
        console.log('[4/5] Navigiere zur Suche...');
        await page.goto('https://resy.dtm-reifen.de/resyweb/index.php?m=wheelset&a=search', {
            waitUntil: 'networkidle',
            timeout: 30000
        });
        
        console.log('[4b/5] Warte auf Suchformular...');
        await page.waitForTimeout(3000);
        
        console.log('[4c/5] Filtere nach Autohaus 453 (Kiel)...');
        await page.selectOption('#WheelKD_ID', '453');
        await page.waitForTimeout(1000);
        
        console.log('[4d/5] Setze Status auf "eingelagert"...');
        await page.selectOption('#WheelSTATUS_ID', '20');
        await page.waitForTimeout(1000);
        
        console.log('[4e/5] Klicke Suchen...');
        await page.click('button[type="submit"]');
        await page.waitForTimeout(8000);
        
        // Finde Gesamtzahl der Seiten
        const totalPages = await page.evaluate(() => {
            const links = document.querySelectorAll('ul#Tablepaginate li.PageLink a');
            let maxPage = 1;
            links.forEach(link => {
                const text = link.querySelector('span')?.textContent;
                const num = parseInt(text);
                if (num && num > maxPage) maxPage = num;
            });
            return maxPage;
        });
        
        console.log(`📄 ${totalPages} Seiten gefunden\n`);
        
        // Lade ALLE Seiten
        let allWheelsets = [];
        
        for (let p = 1; p <= totalPages; p++) {
            if (p > 1) {
                console.log(`📄 Lade Seite ${p}/${totalPages}...`);
                const url = `https://resy.dtm-reifen.de/resyweb/index.php?Page=${p}&FN=WheelsetSearch&a=search&m=wheelset&KD_ID=453&STATUS_ID=20&button=submit`;
                await page.goto(url, { waitUntil: 'networkidle', timeout: 30000 });
                await page.waitForTimeout(5000);
            }
            
            const wheelsets = await page.evaluate(() => {
                const rows = document.querySelectorAll('table.ResultTable tbody tr');
                const data = [];
                rows.forEach(row => {
                    const cells = row.querySelectorAll('td');
                    if (cells.length >= 12) {
                        const satznummer = cells[2]?.textContent.trim();
                        const haltername = cells[3]?.textContent.trim();
                        const kennzeichen = cells[4]?.textContent.trim();
                        const fin = cells[5]?.textContent.trim();
                        const eingangsdatum = cells[8]?.textContent.trim();
                        
                        if (kennzeichen && kennzeichen.length >= 2 && kennzeichen.length <= 20 && kennzeichen !== 'Kennzeichen') {
                            data.push({
                                kennzeichen,
                                satznummer: satznummer || '',
                                marke: 'RESY',
                                modell: haltername || '',
                                oe_nummer: satznummer || '',
                                fin: fin || '',
                                eingangsdatum: eingangsdatum || ''
                            });
                        }
                    }
                });
                return data;
            });
            
            allWheelsets = allWheelsets.concat(wheelsets);
            console.log(`   ✅ Seite ${p}: ${wheelsets.length} Reifensätze`);
        }
        
        console.log(`\n✅ INSGESAMT ${allWheelsets.length} Reifensätze gefunden!\n`);
        
        console.log(JSON.stringify({
            success: true,
            count: allWheelsets.length,
            wheelsets: allWheelsets
        }));
        
    } catch (error) {
        console.error('❌ Fehler:', error.message);
        console.log(JSON.stringify({
            success: false,
            error: error.message,
            wheelsets: []
        }));
    } finally {
        await browser.close();
    }
}

fetchWheelsets();

