<?php
/**
 * Füge Test-Reifensätze in die Datenbank ein
 */

require_once 'config/database.php';

$db = new Database();
$pdo = $db->getConnection();

$testData = [
    [
        'autohaus_id' => 1,
        'kennzeichen' => 'SH-A 123',
        'marke' => 'Michelin',
        'modell' => 'Pilot Sport 4 SUV',
        'oe_nummer' => '245/45R20',
        'reifengroesse' => '245/45R20',
        'status' => 'gelagert'
    ],
    [
        'autohaus_id' => 1,
        'kennzeichen' => 'SH-B 456',
        'marke' => 'Continental',
        'modell' => 'WinterContact TS 850 P',
        'oe_nummer' => '235/55R19',
        'reifengroesse' => '235/55R19',
        'status' => 'gelagert'
    ],
    [
        'autohaus_id' => 1,
        'kennzeichen' => 'SH-C 789',
        'marke' => 'Pirelli',
        'modell' => 'Scorpion Winter',
        'oe_nummer' => '275/35R22',
        'reifengroesse' => '275/35R22',
        'status' => 'gelagert'
    ]
];

echo "📝 Füge Test-Reifensätze ein...\n\n";

$inserted = 0;
foreach ($testData as $data) {
    try {
        $stmt = $pdo->prepare("
            INSERT INTO stored_wheelsets 
            (autohaus_id, kennzeichen, marke, modell, oe_nummer, reifengroesse, status)
            VALUES (?, ?, ?, ?, ?, ?, ?)
        ");
        $stmt->execute([
            $data['autohaus_id'],
            $data['kennzeichen'],
            $data['marke'],
            $data['modell'],
            $data['oe_nummer'],
            $data['reifengroesse'],
            $data['status']
        ]);
        
        echo "✅ Eingefügt: {$data['kennzeichen']} - {$data['marke']} {$data['modell']}\n";
        $inserted++;
    } catch (Exception $e) {
        echo "❌ Fehler bei {$data['kennzeichen']}: " . $e->getMessage() . "\n";
    }
}

echo "\n✅ $inserted Test-Reifensätze eingefügt!\n";

// Zeige alle Einträge
echo "\n📊 Alle Einträge in der Datenbank:\n";
$stmt = $pdo->query("SELECT id, kennzeichen, marke, modell, reifengroesse FROM stored_wheelsets");
$wheelsets = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($wheelsets as $ws) {
    echo "- ID {$ws['id']}: {$ws['kennzeichen']} - {$ws['marke']} {$ws['modell']} ({$ws['reifengroesse']})\n";
}

echo "\n✅ Test-Daten bereit!\n";

