<?php
/**
 * Fix: Füge resy_customer_no Spalte sicher hinzu
 */

require_once 'config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    // Prüfe ob Spalte existiert
    $stmt = $conn->query("SHOW COLUMNS FROM autohaus LIKE 'resy_customer_no'");
    $exists = $stmt->rowCount() > 0;
    
    if (!$exists) {
        echo "⚠️ Spalte 'resy_customer_no' existiert nicht. Füge sie hinzu...\n";
        
        try {
            $conn->exec("ALTER TABLE autohaus ADD COLUMN resy_customer_no VARCHAR(50) NULL AFTER resy_dealer_id");
            echo "✅ Spalte erfolgreich hinzugefügt!\n";
        } catch (PDOException $e) {
            if (strpos($e->getMessage(), 'Duplicate column name') !== false) {
                echo "ℹ️ Spalte existiert bereits.\n";
            } else {
                throw $e;
            }
        }
    } else {
        echo "✅ Spalte 'resy_customer_no' existiert bereits.\n";
    }
    
    // Update alle Autohäuser mit Customer No 201 (falls nicht gesetzt)
    $stmt = $conn->prepare("
        UPDATE autohaus 
        SET resy_customer_no = '201' 
        WHERE resy_customer_no IS NULL 
          AND (resy_username = 'BUE1' OR name LIKE '%B & E%' OR name LIKE '%B&E%')
    ");
    $stmt->execute();
    $updated = $stmt->rowCount();
    
    echo "✅ {$updated} Autohaus(er) mit Customer No '201' aktualisiert.\n";
    
    // Zeige Status
    $stmt = $conn->query("
        SELECT id, name, resy_username, resy_customer_no 
        FROM autohaus 
        WHERE is_active = 1 
        ORDER BY name
    ");
    $autohauser = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "\n📋 Aktuelle Autohaus-Konfiguration:\n";
    echo str_repeat("-", 80) . "\n";
    foreach ($autohauser as $ah) {
        $customerNo = $ah['resy_customer_no'] ?? 'NULL';
        $username = $ah['resy_username'] ?? 'NULL';
        echo sprintf(
            "ID: %-3d | %-30s | User: %-10s | Customer No: %s\n",
            $ah['id'],
            substr($ah['name'], 0, 30),
            $username,
            $customerNo
        );
    }
    
    echo "\n✅ Fix abgeschlossen!\n";
    
} catch (Exception $e) {
    echo "❌ Fehler: " . $e->getMessage() . "\n";
    exit(1);
}

