<?php
/**
 * Debug-Script um RESY-Antworten zu analysieren
 */

// Debug-Script für lokale Entwicklung

$autohausId = $_GET['autohaus_id'] ?? 1;

echo "<h1>RESY Debug für Autohaus ID: $autohausId</h1>";

// Lade die gespeicherten HTML-Dateien
$loginFile = sys_get_temp_dir() . '/resy_login_response_' . $autohausId . '.html';
$searchFile = sys_get_temp_dir() . '/resy_wheelsets_response_' . $autohausId . '.html';

echo "<h2>Login Response</h2>";
if (file_exists($loginFile)) {
    $loginContent = file_get_contents($loginFile);
    echo "<p>Login Response Length: " . strlen($loginContent) . " bytes</p>";
    
    if (strpos($loginContent, 'Anmeldung') !== false) {
        echo "<p style='color: red;'>❌ Login fehlgeschlagen - Anmeldungsformular gefunden</p>";
    } else {
        echo "<p style='color: green;'>✅ Login erfolgreich - Kein Anmeldungsformular gefunden</p>";
    }
    
    // Zeige ersten Teil der Antwort
    echo "<h3>Login Response (erste 1000 Zeichen):</h3>";
    echo "<pre>" . htmlspecialchars(substr($loginContent, 0, 1000)) . "</pre>";
} else {
    echo "<p style='color: orange;'>⚠️ Login Response Datei nicht gefunden: $loginFile</p>";
}

echo "<h2>Search Response</h2>";
if (file_exists($searchFile)) {
    $searchContent = file_get_contents($searchFile);
    echo "<p>Search Response Length: " . strlen($searchContent) . " bytes</p>";
    
    // Prüfe auf verschiedene Indikatoren
    $indicators = [
        'LGS' => 'LGS gefunden',
        'Satznummer' => 'Satznummer gefunden',
        'Kennzeichen' => 'Kennzeichen gefunden',
        'table' => 'Tabelle gefunden',
        'tr' => 'Tabellenzeilen gefunden',
        'td' => 'Tabellenzellen gefunden',
        'Keine Ergebnisse' => 'Keine Ergebnisse gefunden',
        'error' => 'Fehler gefunden'
    ];
    
    echo "<h3>Indikatoren:</h3><ul>";
    foreach ($indicators as $indicator => $description) {
        $found = strpos($searchContent, $indicator) !== false;
        $color = $found ? 'green' : 'red';
        echo "<li style='color: $color;'>" . ($found ? '✅' : '❌') . " $description</li>";
    }
    echo "</ul>";
    
    // Suche nach verschiedenen HTML-Strukturen
    echo "<h3>HTML-Struktur Analyse</h3>";
    
    // 1. Suche nach Tabellen
    if (preg_match_all('/<table[^>]*>(.*?)<\/table>/s', $searchContent, $tables)) {
        echo "<p>✅ Tabellen gefunden: " . count($tables[1]) . "</p>";
    } else {
        echo "<p>❌ Keine Tabellen gefunden</p>";
    }
    
    // 2. Suche nach tbody
    if (preg_match_all('/<tbody[^>]*>(.*?)<\/tbody>/s', $searchContent, $tbodies)) {
        echo "<p>✅ tbody gefunden: " . count($tbodies[1]) . "</p>";
    } else {
        echo "<p>❌ Keine tbody gefunden</p>";
    }
    
    // 3. Suche nach tr (Zeilen)
    if (preg_match_all('/<tr[^>]*>(.*?)<\/tr>/s', $searchContent, $rows)) {
        echo "<p>✅ tr gefunden: " . count($rows[1]) . "</p>";
    } else {
        echo "<p>❌ Keine tr gefunden</p>";
    }
    
    // 4. Suche nach td (Zellen)
    if (preg_match_all('/<td[^>]*>(.*?)<\/td>/s', $searchContent, $cells)) {
        echo "<p>✅ td gefunden: " . count($cells[1]) . "</p>";
    } else {
        echo "<p>❌ Keine td gefunden</p>";
    }
    
    // 5. Suche nach th (Header-Zellen)
    if (preg_match_all('/<th[^>]*>(.*?)<\/th>/s', $searchContent, $headers)) {
        echo "<p>✅ th gefunden: " . count($headers[1]) . "</p>";
    } else {
        echo "<p>❌ Keine th gefunden</p>";
    }
    
    // 6. Suche nach div mit Klassen
    if (preg_match_all('/<div[^>]*class="[^"]*"[^>]*>(.*?)<\/div>/s', $searchContent, $divs)) {
        echo "<p>✅ div mit Klassen gefunden: " . count($divs[1]) . "</p>";
    } else {
        echo "<p>❌ Keine div mit Klassen gefunden</p>";
    }
    
    // 7. Suche nach LGS_ID, Satznummer, Kennzeichen
    if (preg_match('/LGS_ID/', $searchContent)) {
        echo "<p>✅ LGS_ID gefunden</p>";
    } else {
        echo "<p>❌ LGS_ID nicht gefunden</p>";
    }
    
    if (preg_match('/Satznummer/', $searchContent)) {
        echo "<p>✅ Satznummer gefunden</p>";
    } else {
        echo "<p>❌ Satznummer nicht gefunden</p>";
    }
    
    if (preg_match('/Kennzeichen/', $searchContent)) {
        echo "<p>✅ Kennzeichen gefunden</p>";
    } else {
        echo "<p>❌ Kennzeichen nicht gefunden</p>";
    }
    
    // 8. Zeige die ersten 3000 Zeichen der HTML-Antwort
    echo "<h3>HTML-Content (erste 3000 Zeichen)</h3>";
    echo "<pre>" . htmlspecialchars(substr($searchContent, 0, 3000)) . "</pre>";
    
    // Zeige ersten Teil der Antwort
    echo "<h3>Search Response (erste 2000 Zeichen):</h3>";
    echo "<pre>" . htmlspecialchars(substr($searchContent, 0, 2000)) . "</pre>";
    
} else {
    echo "<p style='color: orange;'>⚠️ Search Response Datei nicht gefunden: $searchFile</p>";
}

echo "<h2>Verfügbare Debug-Dateien</h2>";
$debugDir = sys_get_temp_dir();
$files = glob($debugDir . '/resy_*');
echo "<ul>";
foreach ($files as $file) {
    $filename = basename($file);
    $size = filesize($file);
    $modified = date('Y-m-d H:i:s', filemtime($file));
    echo "<li>$filename ($size bytes, $modified)</li>";
}
echo "</ul>";

echo "<p><a href='?autohaus_id=" . ($autohausId + 1) . "'>Nächstes Autohaus testen</a></p>";
?>
