<?php
/**
 * Fix Script für wheelset_offers Status ENUM
 * Erweitert das ENUM um 'new_request' und 'processed'
 */

require_once dirname(__DIR__) . '/config/database.php';

try {
    $database = new Database();
    $conn = $database->getConnection();
    
    if (!$conn) {
        throw new Exception("Keine Datenbankverbindung möglich");
    }
    
    echo "Erweitere Status ENUM...\n";
    
    // Erweitere das ENUM
    $stmt = $conn->prepare("
        ALTER TABLE `wheelset_offers` 
        MODIFY COLUMN `status` ENUM('draft', 'sent', 'viewed', 'accepted', 'declined', 'new_request', 'processed') DEFAULT 'draft'
    ");
    
    $stmt->execute();
    
    echo "✅ Status ENUM erfolgreich erweitert!\n";
    echo "Neue Werte: draft, sent, viewed, accepted, declined, new_request, processed\n";
    
    // Prüfe aktuelle Status-Verteilung
    $stmt = $conn->query("SELECT status, COUNT(*) as count FROM wheelset_offers GROUP BY status");
    $statuses = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "\nAktuelle Status-Verteilung:\n";
    foreach ($statuses as $row) {
        echo "  {$row['status']}: {$row['count']}\n";
    }
    
} catch (Exception $e) {
    echo "❌ Fehler: " . $e->getMessage() . "\n";
    exit(1);
}
?>

