-- Neue stored_wheelsets Tabelle basierend auf RESY HTML-Struktur
-- Multisystem-fähig mit autohaus_id

DROP TABLE IF EXISTS stored_wheelsets_v2;

CREATE TABLE stored_wheelsets_v2 (
    id INT AUTO_INCREMENT PRIMARY KEY,
    autohaus_id INT NOT NULL,
    
    -- Primäre Daten
    satznummer VARCHAR(50) NOT NULL COMMENT 'Satznummer (LGS_ID)',
    haltername VARCHAR(255) COMMENT 'Haltername (NAME1)',
    kennzeichen VARCHAR(20) NOT NULL COMMENT 'Kennzeichen (KENNZEICHEN)',
    fin VARCHAR(50) COMMENT 'Fahrgestellnummer (FAHRGESTNR)',
    
    -- Autohaus-Informationen
    autohaus VARCHAR(100) COMMENT 'Autohaus (KD_ID)',
    ziel_autohaus VARCHAR(100) COMMENT 'Ziel-Autohaus (RUECKKDNAME)',
    
    -- Daten
    eingangsdatum VARCHAR(50) COMMENT 'Eingangsdatum (EINGANG)',
    rueckliefertermin VARCHAR(50) COMMENT 'Rückliefertermin (RUECKLIEFERTERMIN)',
    ausgangsdatum VARCHAR(50) COMMENT 'Ausgangsdatum (AUSGANG)',
    
    -- Reifen-Informationen
    reifenmodell VARCHAR(100) COMMENT 'Reifenmodell (RFMODELL_ID)',
    reifenart VARCHAR(50) COMMENT 'Reifenart (RFARTSUCH_ID)',
    saison VARCHAR(50) COMMENT 'Saison (SAIS_ID)',
    reifengroesse VARCHAR(50) COMMENT 'Reifengröße (VL_GROSS)',
    profiltiefe VARCHAR(50) COMMENT 'Profiltiefe (MINPROFIL)',
    
    -- Status & Metadata
    lagerplatz VARCHAR(50) COMMENT 'Lagerplatz (FORMATLAGERPLATZ)',
    status VARCHAR(50) DEFAULT 'gelagert',
    empfehlung VARCHAR(100) COMMENT 'Empfehlung (MAXEMPFEHL_ID)',
    pruefbericht VARCHAR(100) COMMENT 'Prüfbericht (PRUFDOC_ID)',
    
    -- Mängel
    reifenvorschaden TINYINT(1) DEFAULT 0 COMMENT 'Reifenvorschaden (RFFEHL_FLG)',
    felgenvorschaden TINYINT(1) DEFAULT 0 COMMENT 'Felgenvorschaden (FLGFEHL_FLG)',
    radkappenvorschaden TINYINT(1) DEFAULT 0 COMMENT 'Radkappenvorschaden (RADKAPFEHL_FLG)',
    
    -- Bemerkungen
    rueckgabe_bemerkung TEXT COMMENT 'Rückgabe Bemerkung (RUECKAKTBEMERKUNG)',
    bemerkung TEXT COMMENT 'Bemerkung (KDBEMERK)',
    
    -- System-Felder
    archiviert TINYINT(1) DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    
    INDEX idx_autohaus_id (autohaus_id),
    INDEX idx_kennzeichen (kennzeichen),
    INDEX idx_satznummer (satznummer),
    INDEX idx_status (status),
    INDEX idx_archiviert (archiviert),
    INDEX idx_eingangsdatum (eingangsdatum),
    
    FOREIGN KEY (autohaus_id) REFERENCES autohaus(id) ON DELETE CASCADE,
    UNIQUE KEY unique_wheelset (autohaus_id, kennzeichen, satznummer)
    
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

