<?php
require_once __DIR__ . '/config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();

    $conn->exec("DROP TABLE IF EXISTS api_replay_nonce");
    $conn->exec("DROP TABLE IF EXISTS api_key_usage");
    $conn->exec("DROP TABLE IF EXISTS api_keys");

    $sql = file_get_contents(__DIR__ . '/database/create_api_security_tables.sql');
    foreach (array_filter(array_map('trim', explode(';', $sql))) as $stmt) {
        if ($stmt === '' || strpos($stmt, '--') === 0) continue;
        $conn->exec($stmt);
    }
    echo "Recreate OK\n";
} catch (Throwable $e) {
    echo "ERROR: ".$e->getMessage()."\n";
    exit(1);
}
