<?php
/**
 * Wheelset Kommentare API
 * CRUD-Operationen für Radsatz-Kommentare
 */

header('Content-Type: application/json');
session_start();

if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Nicht autorisiert']);
    exit;
}

require_once dirname(__DIR__) . '/config/database.php';

$db = new Database();
$conn = $db->getConnection();
$current_user_id = $_SESSION['admin_user_id'] ?? null;

$method = $_SERVER['REQUEST_METHOD'];
$action = $_GET['action'] ?? '';

try {
    switch ($action) {
        case 'get':
            // GET - Kommentar lesen
            $wheelsetNumber = $_GET['wheelset_number'] ?? '';
            $autohausId = $_GET['autohaus_id'] ?? '';
            
            if (!$wheelsetNumber || !$autohausId) {
                throw new Exception('wheelset_number und autohaus_id sind erforderlich');
            }
            
            $stmt = $conn->prepare("
                SELECT id, wheelset_number, comment, created_by, created_at, updated_at
                FROM wheelset_comments
                WHERE wheelset_number = ? AND autohaus_id = ?
            ");
            $stmt->execute([$wheelsetNumber, $autohausId]);
            $comment = $stmt->fetch(PDO::FETCH_ASSOC);
            
            echo json_encode([
                'success' => true,
                'comment' => $comment ? $comment['comment'] : '',
                'data' => $comment
            ]);
            break;
            
        case 'save':
        case 'update':
            // POST/PUT - Kommentar speichern/aktualisieren
            $data = json_decode(file_get_contents('php://input'), true);
            
            $wheelsetNumber = $data['wheelset_number'] ?? '';
            $autohausId = $data['autohaus_id'] ?? '';
            $comment = $data['comment'] ?? '';
            
            if (!$wheelsetNumber || !$autohausId) {
                throw new Exception('wheelset_number und autohaus_id sind erforderlich');
            }
            
            // Prüfe ob Kommentar existiert
            $stmt = $conn->prepare("
                SELECT id FROM wheelset_comments
                WHERE wheelset_number = ? AND autohaus_id = ?
            ");
            $stmt->execute([$wheelsetNumber, $autohausId]);
            $exists = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($exists) {
                // Update
                $stmt = $conn->prepare("
                    UPDATE wheelset_comments
                    SET comment = ?, updated_at = CURRENT_TIMESTAMP
                    WHERE wheelset_number = ? AND autohaus_id = ?
                ");
                $stmt->execute([$comment, $wheelsetNumber, $autohausId]);
            } else {
                // Insert
                $stmt = $conn->prepare("
                    INSERT INTO wheelset_comments (wheelset_number, autohaus_id, comment, created_by)
                    VALUES (?, ?, ?, ?)
                ");
                $stmt->execute([$wheelsetNumber, $autohausId, $comment, $current_user_id]);
            }
            
            echo json_encode([
                'success' => true,
                'message' => 'Kommentar gespeichert'
            ]);
            break;
            
        case 'delete':
            // DELETE - Kommentar löschen
            $data = json_decode(file_get_contents('php://input'), true);
            
            $wheelsetNumber = $data['wheelset_number'] ?? '';
            $autohausId = $data['autohaus_id'] ?? '';
            
            if (!$wheelsetNumber || !$autohausId) {
                throw new Exception('wheelset_number und autohaus_id sind erforderlich');
            }
            
            $stmt = $conn->prepare("
                DELETE FROM wheelset_comments
                WHERE wheelset_number = ? AND autohaus_id = ?
            ");
            $stmt->execute([$wheelsetNumber, $autohausId]);
            
            echo json_encode([
                'success' => true,
                'message' => 'Kommentar gelöscht'
            ]);
            break;
            
        default:
            throw new Exception('Ungültige Action');
    }
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

