<?php
/**
 * Sicherer Viewer für Autohaus-Footer-Bilder
 * Liefert Bilder über Proxy aus (öffentlich zugänglich für Frontend)
 */

$filename = $_GET['file'] ?? null;

if (!$filename) {
    http_response_code(400);
    die('Dateiname erforderlich');
}

// Sicherheitsprüfung: Nur Dateien aus dem autohaus_footer Verzeichnis erlauben
$base_upload_dir = realpath(__DIR__ . '/../uploads/autohaus_footer/');

// Pfad sanitisieren
$clean_path = basename($filename); // Nur Dateiname, kein Pfad-Traversal
$full_path = $base_upload_dir . '/' . $clean_path;
$requested_path = realpath($full_path);

// Prüfe ob Datei im erlaubten Verzeichnis liegt
if (!$requested_path || substr($requested_path, 0, strlen($base_upload_dir)) !== $base_upload_dir) {
    http_response_code(403);
    die('Zugriff verweigert: Ungültiger Dateipfad');
}

// Prüfe ob Datei existiert
if (!file_exists($requested_path)) {
    http_response_code(404);
    die('Datei nicht gefunden');
}

// Bestimme MIME-Type
$mime_type = mime_content_type($requested_path);
$allowed_types = ['image/jpeg', 'image/jpg', 'image/png', 'image/webp'];

if (!in_array($mime_type, $allowed_types)) {
    http_response_code(403);
    die('Dateityp nicht erlaubt: ' . $mime_type);
}

// Setze entsprechende Header
header('Content-Type: ' . $mime_type);
header('Content-Length: ' . filesize($requested_path));
header('Cache-Control: private, max-age=86400'); // 24 Stunden Cache
header('Content-Disposition: inline; filename="' . basename($requested_path) . '"');

// Output der Datei
readfile($requested_path);

