<?php
/**
 * update_device_token.php
 * Speichert oder aktualisiert das Device Token für Push-Benachrichtigungen
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

require_once 'config.php';

try {
    // Authentifizierung prüfen
    $userId = null;
    
    // 1. Bearer Token
    $headers = getallheaders();
    $authToken = null;
    if ($headers) {
        foreach ($headers as $key => $value) {
            if (strtolower($key) === 'authorization' && stripos($value, 'bearer ') === 0) {
                $authToken = trim(substr($value, 7));
                break;
            }
        }
    }
    
    if ($authToken) {
        $stmt = $pdo->prepare("SELECT id FROM users WHERE auth_token = ? AND token_expires_at > NOW() AND is_active = 1 LIMIT 1");
        $stmt->execute([$authToken]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($user) {
            $userId = (int)$user['id'];
        }
    }
    
    // 2. Session (Fallback)
    if (!$userId && session_status() === PHP_SESSION_ACTIVE && isset($_SESSION['user_id'])) {
        $userId = (int)$SESSION['user_id'];
    }
    
    if (!$userId) {
        http_response_code(401);
        echo json_encode(['success' => false, 'message' => 'Nicht angemeldet']);
        exit;
    }
    
    // Input lesen
    $input = json_decode(file_get_contents('php://input'), true);
    if (!$input || empty($input['device_token'])) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'device_token ist erforderlich']);
        exit;
    }
    
    $deviceToken = trim($input['device_token']);
    $deviceType = $input['device_type'] ?? 'ios';
    
    // Prüfe ob Token bereits existiert für diesen User
    $stmt = $pdo->prepare("SELECT id FROM user_device_tokens WHERE user_id = ? AND device_token = ? LIMIT 1");
    $stmt->execute([$userId, $deviceToken]);
    $existing = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($existing) {
        // Aktualisiere updated_at
        $stmt = $pdo->prepare("UPDATE user_device_tokens SET updated_at = NOW() WHERE id = ?");
        $stmt->execute([$existing['id']]);
    } else {
        // Neues Token einfügen
        $stmt = $pdo->prepare("
            INSERT INTO user_device_tokens (user_id, device_token, device_type, created_at, updated_at)
            VALUES (?, ?, ?, NOW(), NOW())
        ");
        $stmt->execute([$userId, $deviceToken, $deviceType]);
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'Device Token gespeichert'
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    error_log("update_device_token.php ERROR: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Fehler beim Speichern des Device Tokens'
    ]);
}
?>

