<?php
/**
 * RESY Session Manager - Verwaltet PHPSESSID
 */

class ResySessionManager {
    private $sessionFile;
    
    public function __construct() {
        $this->sessionFile = __DIR__ . '/../temp/resy_session.json';
    }
    
    /**
     * Hole aktuelle Session oder erstelle neue
     */
    public function getSession() {
        if (file_exists($this->sessionFile)) {
            $data = json_decode(file_get_contents($this->sessionFile), true);
            
            // Prüfe ob Session noch gültig (max 1 Stunde alt)
            if (isset($data['expires_at']) && $data['expires_at'] > time()) {
                return $data;
            }
        }
        
        // Neue Session erstellen
        return $this->createNewSession();
    }
    
    /**
     * Erstelle neue RESY Session
     */
    public function createNewSession() {
        $loginUrl = 'https://resy.dtm-reifen.de/index.php?m=login&a=login';
        
        // Cookie-Jar
        $cookieFile = sys_get_temp_dir() . '/resy_' . uniqid() . '.txt';
        
        // 1. Hole Login-Seite
        $ch = curl_init($loginUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, true);
        curl_setopt($ch, CURLOPT_COOKIEFILE, $cookieFile);
        curl_setopt($ch, CURLOPT_COOKIEJAR, $cookieFile);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        
        $response = curl_exec($ch);
        curl_close($ch);
        
        // Extrahiere PHPSESSID
        $sessionId = null;
        preg_match('/PHPSESSID=([^;]+)/', $response, $matches);
        if (!empty($matches[1])) {
            $sessionId = $matches[1];
        }
        
        // 2. Submit Login
        $stmt = $GLOBALS['pdo'] ?? null;
        if (!$stmt) {
            require_once dirname(__DIR__) . '/config/database.php';
            $db = new Database();
            $stmt = $db->getConnection()->prepare("SELECT resy_username, resy_password FROM autohaus WHERE id = 1");
            $stmt->execute();
            $creds = $stmt->fetch(PDO::FETCH_ASSOC);
        } else {
            $creds = ['resy_username' => 'D.ULUDAG', 'resy_password' => 'Ikizler123!'];
        }
        
        $postData = http_build_query([
            'InputUser' => $creds['resy_username'],
            'InputPass' => $creds['resy_password'],
            'button' => 'Anmelden'
        ]);
        
        $ch = curl_init($loginUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
        curl_setopt($ch, CURLOPT_COOKIEFILE, $cookieFile);
        curl_setopt($ch, CURLOPT_COOKIEJAR, $cookieFile);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_HEADER, true);
        
        $loginResponse = curl_exec($ch);
        $finalUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
        curl_close($ch);
        
        // Lese alle Cookies
        $cookies = file_get_contents($cookieFile);
        @unlink($cookieFile);
        
        // Speichere Session
        $sessionData = [
            'phpsessid' => $sessionId,
            'cookies' => $cookies,
            'created_at' => time(),
            'expires_at' => time() + 3600, // 1 Stunde
            'login_status' => strpos($finalUrl, 'resyweb') !== false
        ];
        
        file_put_contents($this->sessionFile, json_encode($sessionData));
        
        return $sessionData;
    }
    
    /**
     * Nutze Session für Request
     */
    public function makeRequest($url) {
        $session = $this->getSession();
        
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_COOKIE, $session['cookies']);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)');
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($httpCode === 200 && $response) {
            return $response;
        }
        
        // Session abgelaufen - neu erstellen
        @unlink($this->sessionFile);
        return $this->makeRequest($url);
    }
}
