<?php
/**
 * RESY REST API Routes - Alle verfügbaren Endpunkte
 * Zentrale API für alle RESY-Operationen
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once dirname(__DIR__) . '/config/database.php';
require_once __DIR__ . '/resy_rest_api_complete.php';

$action = $_GET['action'] ?? $_POST['action'] ?? '';
$autohausId = $_GET['autohaus_id'] ?? $_POST['autohaus_id'] ?? 1;

try {
    $api = new ResyRestAPIComplete($autohausId);
    
    switch ($action) {
        // ============ WHEELSETS ============
        case 'get_wheelsets':
            $wheelsets = $api->getAllWheelsetsSmart();
            echo json_encode([
                'success' => true,
                'wheelsets' => $wheelsets,
                'count' => count($wheelsets),
                'autohaus_id' => $autohausId
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
            
        case 'get_wheelset_details':
            $wheelsetNumber = $_GET['wheelset_number'] ?? $_POST['wheelset_number'] ?? null;
            if (!$wheelsetNumber) {
                throw new Exception("wheelset_number Parameter erforderlich");
            }
            $details = $api->getWheelsetDetails($wheelsetNumber);
            echo json_encode([
                'success' => true,
                'wheelset' => $details
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
            
        case 'get_wheelsets_by_vehicle':
            $vin = $_GET['vin'] ?? $_POST['vin'] ?? null;
            $licenseNo = $_GET['license_no'] ?? $_POST['license_no'] ?? null;
            $wheelsets = $api->getWheelsetsByVehicle($vin, $licenseNo);
            echo json_encode([
                'success' => true,
                'wheelsets' => $wheelsets
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
        
        // ============ PICKUP ORDERS ============
        case 'get_pickup_orders':
            $customerNo = $_GET['customer_no'] ?? $_POST['customer_no'] ?? null;
            $orders = $api->getPickupOrders($customerNo);
            echo json_encode([
                'success' => true,
                'pickupOrders' => $orders,
                'count' => count($orders)
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
            
        case 'create_pickup_order':
            $customerNo = $_POST['customer_no'] ?? null;
            $orders = $_POST['pickupOrders'] ?? [];
            if (empty($orders)) {
                throw new Exception("pickupOrders Array erforderlich");
            }
            $result = $api->createPickupOrder($customerNo ?? $api->customerNo, $orders);
            echo json_encode([
                'success' => true,
                'result' => $result
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
            
        case 'delete_pickup_order':
            $wheelsetNumber = $_POST['wheelset_number'] ?? $_GET['wheelset_number'] ?? null;
            if (!$wheelsetNumber) {
                throw new Exception("wheelset_number Parameter erforderlich");
            }
            $result = $api->deletePickupOrder($wheelsetNumber);
            echo json_encode([
                'success' => true,
                'result' => $result
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
        
        // ============ RETURN ORDERS ============
        case 'get_return_orders':
            $customerNo = $_GET['customer_no'] ?? $_POST['customer_no'] ?? null;
            $orders = $api->getReturnOrders($customerNo);
            echo json_encode([
                'success' => true,
                'returnOrders' => $orders,
                'count' => count($orders)
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
            
        case 'create_return_order':
            $customerNo = $_POST['customer_no'] ?? null;
            $orders = $_POST['returnOrders'] ?? [];
            if (empty($orders)) {
                throw new Exception("returnOrders Array erforderlich");
            }
            $result = $api->createReturnOrder($customerNo ?? $api->customerNo, $orders);
            echo json_encode([
                'success' => true,
                'result' => $result
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
            
        case 'delete_return_order':
            $wheelsetNumber = $_POST['wheelset_number'] ?? $_GET['wheelset_number'] ?? null;
            if (!$wheelsetNumber) {
                throw new Exception("wheelset_number Parameter erforderlich");
            }
            $result = $api->deleteReturnOrder($wheelsetNumber);
            echo json_encode([
                'success' => true,
                'result' => $result
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
        
        // ============ CUSTOMER INFO ============
        case 'get_customer_details':
            $customerNo = $_GET['customer_no'] ?? $_POST['customer_no'] ?? null;
            $details = $api->getCustomerDetails($customerNo);
            echo json_encode([
                'success' => true,
                'customer' => $details
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
            
        case 'get_allowed_customers':
            $customers = $api->getAllowedCustomers();
            echo json_encode([
                'success' => true,
                'customers' => $customers
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
            
        case 'get_service_packages':
            $customerNo = $_GET['customer_no'] ?? $_POST['customer_no'] ?? null;
            $packages = $api->getServicePackages($customerNo);
            echo json_encode([
                'success' => true,
                'servicePackages' => $packages
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
            
        case 'get_inventory':
            $customerNo = $_GET['customer_no'] ?? $_POST['customer_no'] ?? null;
            $inventory = $api->getInventory($customerNo);
            echo json_encode([
                'success' => true,
                'inventory' => $inventory
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
            
        case 'get_global_inventory':
            $inventory = $api->getGlobalInventory();
            echo json_encode([
                'success' => true,
                'inventory' => $inventory
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
            
        case 'get_pickup_order_dates':
            $customerNo = $_GET['customer_no'] ?? $_POST['customer_no'] ?? null;
            $dates = $api->getPickupOrderDates($customerNo);
            echo json_encode([
                'success' => true,
                'orderDays' => $dates
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
            
        case 'get_return_order_dates':
            $customerNo = $_GET['customer_no'] ?? $_POST['customer_no'] ?? null;
            $dates = $api->getReturnOrderDates($customerNo);
            echo json_encode([
                'success' => true,
                'orderDays' => $dates
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
            
        case 'get_delivery_options':
            $customerNo = $_GET['customer_no'] ?? $_POST['customer_no'] ?? null;
            $options = $api->getDeliveryOptions($customerNo);
            echo json_encode([
                'success' => true,
                'deliveryOptions' => $options
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
            
        case 'get_loading_points':
            $customerNo = $_GET['customer_no'] ?? $_POST['customer_no'] ?? null;
            $points = $api->getLoadingPoints($customerNo);
            echo json_encode([
                'success' => true,
                'loadingPoints' => $points
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
            
        case 'get_order_times':
            $customerNo = $_GET['customer_no'] ?? $_POST['customer_no'] ?? null;
            $times = $api->getOrderTimes($customerNo);
            echo json_encode([
                'success' => true,
                'orderTimes' => $times
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
            
        case 'get_pickup_order_dates_custom':
            $customerNo = $_GET['customer_no'] ?? $_POST['customer_no'] ?? null;
            $date = $_GET['date'] ?? $_POST['date'] ?? null;
            $forwardDays = $_GET['forwardDays'] ?? $_POST['forwardDays'] ?? 30;
            if (!$date) {
                throw new Exception("date Parameter erforderlich");
            }
            $dates = $api->getPickupOrderDatesCustom($customerNo ?? $api->customerNo, $date, intval($forwardDays));
            echo json_encode([
                'success' => true,
                'orderDays' => $dates
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
            
        case 'get_return_order_dates_custom':
            $customerNo = $_GET['customer_no'] ?? $_POST['customer_no'] ?? null;
            $date = $_GET['date'] ?? $_POST['date'] ?? null;
            $forwardDays = $_GET['forwardDays'] ?? $_POST['forwardDays'] ?? 30;
            if (!$date) {
                throw new Exception("date Parameter erforderlich");
            }
            $dates = $api->getReturnOrderDatesCustom($customerNo ?? $api->customerNo, $date, intval($forwardDays));
            echo json_encode([
                'success' => true,
                'orderDays' => $dates
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
        
        // ============ TOOLS ============
        case 'check_wheelset':
            $wheelsetNumber = $_GET['wheelset_number'] ?? $_POST['wheelset_number'] ?? null;
            if (!$wheelsetNumber) {
                throw new Exception("wheelset_number Parameter erforderlich");
            }
            $result = $api->checkWheelsetNumber($wheelsetNumber);
            echo json_encode([
                'success' => true,
                'result' => $result
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
            
        case 'check_license_plate':
            $plate = $_GET['license_plate'] ?? $_POST['license_plate'] ?? null;
            if (!$plate) {
                throw new Exception("license_plate Parameter erforderlich");
            }
            $result = $api->checkLicencePlate($plate);
            echo json_encode([
                'success' => true,
                'result' => $result
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
            
        case 'check_vin':
            $vin = $_GET['vin'] ?? $_POST['vin'] ?? null;
            if (!$vin) {
                throw new Exception("vin Parameter erforderlich");
            }
            $result = $api->checkVIN($vin);
            echo json_encode([
                'success' => true,
                'result' => $result
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
        
        // ============ EXTRA ORDERS ============
        case 'get_all_extra_orders':
            $orders = $api->getAllExtraOrders();
            echo json_encode([
                'success' => true,
                'extraOrders' => $orders,
                'count' => count($orders)
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
            
        case 'get_customer_extra_orders':
            $customerNo = $_GET['customer_no'] ?? $_POST['customer_no'] ?? null;
            // getExtraOrders gibt mögliche Extra Orders für einen Kunden zurück
            $orders = $api->getExtraOrders($customerNo ?? $api->customerNo);
            echo json_encode([
                'success' => true,
                'extraOrders' => $orders
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
            
        case 'create_extra_order':
            $data = json_decode(file_get_contents('php://input'), true);
            if (!$data || !isset($data['name']) || !isset($data['quantity'])) {
                throw new Exception("name und quantity sind erforderlich");
            }
            // Setze customerNo automatisch falls nicht gesetzt
            if (!isset($data['customerNo']) || empty($data['customerNo'])) {
                $data['customerNo'] = $api->customerNo;
            }
            $result = $api->createExtraOrder($data);
            echo json_encode([
                'success' => true,
                'result' => $result
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            break;
        
        default:
            throw new Exception("Unbekannte Aktion: " . $action);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
}

