<?php
/**
 * Benachrichtigung als gelesen markieren
 */

session_start();

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Prüfe ob User eingeloggt ist
if (!isset($_SESSION['user_logged_in']) || !$_SESSION['user_logged_in']) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Nicht autorisiert']);
    exit;
}

require_once __DIR__ . '/../config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    $input = json_decode(file_get_contents('php://input'), true);
    $notification_id = intval($input['notification_id'] ?? 0);
    $user_id = $_SESSION['user_id'];
    
    if ($notification_id <= 0) {
        throw new Exception('Ungültige Benachrichtigungs-ID');
    }
    
    // Prüfe ob Benachrichtigung dem User gehört
    $stmt = $conn->prepare("SELECT id FROM user_notifications WHERE id = ? AND user_id = ?");
    $stmt->execute([$notification_id, $user_id]);
    
    if (!$stmt->fetch()) {
        throw new Exception('Benachrichtigung nicht gefunden');
    }
    
    // Als gelesen markieren
    $stmt = $conn->prepare("UPDATE user_notifications SET is_read = 1 WHERE id = ? AND user_id = ?");
    $result = $stmt->execute([$notification_id, $user_id]);
    
    if ($result) {
        echo json_encode([
            'success' => true,
            'message' => 'Benachrichtigung als gelesen markiert'
        ]);
    } else {
        throw new Exception('Fehler beim Aktualisieren');
    }
    
} catch (\Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>

