<?php
/**
 * Proxy-API für Reifenbilder
 * Lädt Bilder von RESY mit korrekter Session
 */

// Fehlerbehandlung
error_reporting(E_ALL);
ini_set('display_errors', 0);

// Setze Content-Type für Bilder
header('Content-Type: image/jpeg');

try {
    // Lade die LGFOTO_ID
    $lgfotoId = $_GET['lgfoto_id'] ?? null;
    
    if (!$lgfotoId) {
        throw new Exception('LGFOTO_ID fehlt');
    }
    
    // Lade die Autohaus-Daten
    require_once '../config/database.php';
    
    // Stelle sicher, dass die Variablen definiert sind
    if (!isset($dsn) || !isset($username) || !isset($password) || !isset($options)) {
        throw new Exception('Datenbank-Konfiguration fehlt');
    }
    
    $pdo = new PDO($dsn, $username, $password, $options);
    
    // Verwende Autohaus ID 2 (B & E Volvo Norderstedt) wie in der Haupt-API
    $stmt = $pdo->prepare("SELECT * FROM autohaus WHERE id = ?");
    $stmt->execute([2]); // Verwende Autohaus ID 2
    $autohaus = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$autohaus) {
        throw new Exception('Autohaus nicht gefunden');
    }
    
    // Extrahiere die RESY Kunden-ID
    $resyKdId = null;
    if (preg_match('/(\d+)/', $autohaus['resy_dealer_id'], $matches)) {
        $resyKdId = $matches[1];
    }
    
    if (!$resyKdId) {
        throw new Exception('RESY Kunden-ID nicht gefunden');
    }
    
    // Erstelle eine temporäre Cookie-Datei
    $cookieFile = tempnam(sys_get_temp_dir(), 'resy_cookies_');
    
    // Login zu RESY
    $loginUrl = 'https://resy.dtm-reifen.de/index.php?m=login&a=login&FN=Login';
    $loginData = [
        'KD_ID' => $resyKdId,
        'USERNAME' => $autohaus['resy_username'],
        'PASSWORD' => $autohaus['resy_password'],
        'LOGIN' => 'Anmelden'
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $loginUrl);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($loginData));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_COOKIEJAR, $cookieFile);
    curl_setopt($ch, CURLOPT_COOKIEFILE, $cookieFile);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36');
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    
    if ($error) {
        throw new Exception("cURL-Fehler: $error");
    }
    
    if ($httpCode !== 200) {
        throw new Exception("HTTP-Fehler: $httpCode");
    }
    
    // Lade das Bild
    $imageUrl = "https://resy.dtm-reifen.de/index.php?m=wheelphoto&a=show&LGFOTO_ID=$lgfotoId&FN=ShowPruefDoc";
    
    curl_setopt($ch, CURLOPT_URL, $imageUrl);
    curl_setopt($ch, CURLOPT_POST, false);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Accept: image/webp,image/apng,image/*,*/*;q=0.8',
        'Accept-Language: de-DE,de;q=0.9,en;q=0.8',
        'Referer: https://resy.dtm-reifen.de/index.php?m=wheelset&a=search&FN=WheelsetSearch'
    ]);
    
    $imageData = curl_exec($ch);
    $imageHttpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $contentType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
    
    curl_close($ch);
    
    // Lösche die Cookie-Datei
    if (file_exists($cookieFile)) {
        unlink($cookieFile);
    }
    
    if ($imageHttpCode !== 200) {
        throw new Exception("Bild konnte nicht geladen werden: HTTP $imageHttpCode");
    }
    
    // Setze den korrekten Content-Type
    if ($contentType) {
        header('Content-Type: ' . $contentType);
    }
    
    // Gib das Bild aus
    echo $imageData;
    
} catch (Exception $e) {
    // Bei Fehlern zeige ein Placeholder-Bild
    error_log("Bild-Proxy-Fehler: " . $e->getMessage());
    
    // Lade das Placeholder-Bild
    $placeholderUrl = 'https://resy.dtm-reifen.de/application/view/img/resyauto.png';
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $placeholderUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
    
    $placeholderData = curl_exec($ch);
    curl_close($ch);
    
    if ($placeholderData) {
        header('Content-Type: image/png');
        echo $placeholderData;
    } else {
        // Fallback: Zeige einen Fehler
        header('Content-Type: text/plain');
        echo 'Bild konnte nicht geladen werden';
    }
}
?>
