<?php
/**
 * RESY-Datenabruf mit Session-Cookies
 * Nutzt bestehende Cookies für direkte cURL-Requests
 */

header('Content-Type: application/json');
require_once dirname(__DIR__) . '/config/database.php';

$autohausId = $_GET['autohaus_id'] ?? 1;

// Lade Credentials
$db = new Database();
$pdo = $db->getConnection();

$stmt = $pdo->prepare("SELECT name, resy_username, resy_password FROM autohaus WHERE id = ?");
$stmt->execute([$autohausId]);
$autohaus = $stmt->fetch(PDO::FETCH_ASSOC);

$mapping = [
    'B & E Volvo Kiel' => '453',
    'B & E Volvo Norderstedt' => '452',
    'B & E Volvo Glinde' => '454'
];
$dealerId = $mapping[$autohaus['name'] ?? ''] ?? '453';

// Versuche Login und hole Session-Cookies
$cookies = [];
$loginUrl = 'https://resy.dtm-reifen.de/index.php?m=login&a=login';

// 1. Login-Request
$ch = curl_init($loginUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_COOKIEJAR, sys_get_temp_dir() . '/resy_cookies.txt');
curl_setopt($ch, CURLOPT_COOKIEFILE, sys_get_temp_dir() . '/resy_cookies.txt');
curl_setopt($ch, CURLOPT_HEADER, true);

$response = curl_exec($ch);
curl_close($ch);

// Parse Cookies
preg_match_all('/Set-Cookie: ([^;]+)/', $response, $matches);
foreach ($matches[1] ?? [] as $cookie) {
    $parts = explode('=', $cookie, 2);
    if (count($parts) === 2) {
        $cookies[$parts[0]] = $parts[1];
    }
}

// 2. Submit Login
$postData = http_build_query([
    'InputUser' => $autohaus['resy_username'],
    'InputPass' => $autohaus['resy_password'],
    'button' => 'Anmelden'
]);

$ch = curl_init($loginUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
curl_setopt($ch, CURLOPT_COOKIEJAR, sys_get_temp_dir() . '/resy_cookies.txt');
curl_setopt($ch, CURLOPT_COOKIEFILE, sys_get_temp_dir() . '/resy_cookies.txt');
curl_setopt($ch, CURLOPT_HEADER, true);

$loginResponse = curl_exec($ch);
curl_close($ch);

// 3. Hole Reifensätze mit Session
$searchUrl = "https://resy.dtm-reifen.de/index.php?m=wheelset&a=search&FN=WheelsetSearch&KD_ID=$dealerId&STATUS_ID=20";

$ch = curl_init($searchUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_COOKIEJAR, sys_get_temp_dir() . '/resy_cookies.txt');
curl_setopt($ch, CURLOPT_COOKIEFILE, sys_get_temp_dir() . '/resy_cookies.txt');
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');

$html = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode === 200 && $html) {
    // Parse HTML
    libxml_use_internal_errors(true);
    $dom = new DOMDocument();
    $dom->loadHTML($html);
    $xpath = new DOMXPath($dom);
    
    $rows = $xpath->query('//tr');
    $wheelsets = [];
    
    foreach ($rows as $row) {
        $cells = $xpath->query('./td', $row);
        
        if ($cells->length >= 2) {
            $kennzeichen = trim($cells->item(0)->textContent ?? '');
            
            if (strlen($kennzeichen) >= 2 && strlen($kennzeichen) <= 20) {
                $wheelsets[] = [
                    'kennzeichen' => $kennzeichen,
                    'satznummer' => trim($cells->item(1)->textContent ?? ''),
                    'marke' => 'RESY',
                    'modell' => '',
                    'oe_nummer' => ''
                ];
            }
        }
    }
    
    // Speichere in DB
    foreach ($wheelsets as $ws) {
        $stmt = $pdo->prepare("
            INSERT INTO stored_wheelsets 
            (autohaus_id, kennzeichen, marke, modell, oe_nummer, status, updated_at)
            VALUES (?, ?, ?, ?, ?, 'gelagert', NOW())
            ON DUPLICATE KEY UPDATE updated_at = NOW()
        ");
        $stmt->execute([
            $autohausId,
            $ws['kennzeichen'],
            $ws['marke'],
            $ws['modell'],
            $ws['oe_nummer']
        ]);
    }
    
    echo json_encode([
        'success' => true,
        'count' => count($wheelsets),
        'wheelsets' => $wheelsets,
        'message' => count($wheelsets) . ' Reifensätze von RESY geladen',
        'source' => 'resy'
    ]);
} else {
    echo json_encode([
        'success' => false,
        'error' => 'RESY nicht erreichbar (HTTP ' . $httpCode . ')',
        'count' => 0,
        'wheelsets' => []
    ]);
}

