<?php
/**
 * RESY-Datenabruf via Node.js
 */

require_once dirname(__DIR__) . '/config/database.php';

$autohausId = $_GET['autohaus_id'] ?? 1;

// Lade Credentials
$db = new Database();
$pdo = $db->getConnection();

$stmt = $pdo->prepare("SELECT name, resy_username, resy_password FROM autohaus WHERE id = ?");
$stmt->execute([$autohausId]);
$autohaus = $stmt->fetch(PDO::FETCH_ASSOC);

$mapping = [
    'B & E Volvo Kiel' => '453',
    'B & E Volvo Norderstedt' => '452',
    'B & E Volvo Glinde' => '454'
];
$dealerId = $mapping[$autohaus['name'] ?? ''] ?? '453';

// Rufe Node.js-Script auf
$nodeScript = __DIR__ . '/../get_resy_node.js';
$command = "node \"$nodeScript\" \"{$autohaus['resy_username']}\" \"{$autohaus['resy_password']}\" \"$dealerId\"";

$output = shell_exec($command);
$result = json_decode($output, true);

if ($result && isset($result['success']) && $result['success']) {
    // Speichere in Datenbank
    $wheelsets = $result['wheelsets'] ?? [];
    
    foreach ($wheelsets as $ws) {
        $stmt = $pdo->prepare("
            INSERT INTO stored_wheelsets 
            (autohaus_id, kennzeichen, marke, modell, oe_nummer, status, updated_at)
            VALUES (?, ?, ?, ?, ?, 'gelagert', NOW())
            ON DUPLICATE KEY UPDATE updated_at = NOW()
        ");
        $stmt->execute([
            $autohausId,
            $ws['kennzeichen'],
            $ws['marke'] ?? 'RESY',
            $ws['modell'] ?? '',
            $ws['oe_nummer'] ?? '',
        ]);
    }
    
    echo json_encode([
        'success' => true,
        'count' => count($wheelsets),
        'wheelsets' => $wheelsets,
        'message' => count($wheelsets) . ' Reifensätze von RESY geladen'
    ]);
} else {
    echo json_encode([
        'success' => false,
        'error' => $result['error'] ?? 'Unbekannter Fehler'
    ]);
}

