<?php
/**
 * Pending Users für Admin Dashboard
 */
session_start();
require_once __DIR__ . '/../admin/includes/auth.php';

// Prüfe ob Admin eingeloggt ist
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Nicht autorisiert']);
    exit;
}

require_once 'config.php';

header('Content-Type: application/json');

try {
    // Prüfe welcher Status gewünscht ist
    $status = $_GET['status'] ?? 'pending';
    
    $stmt = $pdo->prepare("
        SELECT id, first_name, last_name, email, phone_number, license_plate, 
               verification_status, verification_document, verification_reason, 
               verified_at, created_at
        FROM users 
        WHERE verification_status = ? 
        ORDER BY created_at DESC
    ");
    $stmt->execute([$status]);
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'users' => $users
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>

