<?php
// config.php - Verwendet bestehende Datenbankverbindung
require_once __DIR__ . '/../config/database.php';

// Verwende die bestehende Database-Klasse
$db = new Database();
$pdo = $db->getConnection();

// API-Konfiguration
define('API_KEY', 'd7f9c2a4b3e8f1c05a6e4d9b7f3c1a2e9b6c4d7e2a9f1c0b6e2d3f4a5b6c7d8');
define('JWT_SECRET', 'your_jwt_secret_key_here');
define('UPLOAD_MAX_SIZE', 5 * 1024 * 1024); // 5MB
define('ALLOWED_IMAGE_TYPES', ['image/jpeg', 'image/png', 'image/gif']);

// Hilfsfunktionen
function validateEmail($email) {
    return filter_var($email, FILTER_VALIDATE_EMAIL) !== false;
}

function generateAuthToken() {
    return bin2hex(random_bytes(32));
}

function hashPassword($password) {
    return password_hash($password, PASSWORD_DEFAULT);
}

function verifyPassword($password, $hash) {
    return password_verify($password, $hash);
}

function sanitizeInput($input) {
    return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
}

function logError($message) {
    error_log(date('Y-m-d H:i:s') . " - " . $message);
}
?>
