<?php
// Analysiere die Wheelsets-Antwort
$htmlFile = sys_get_temp_dir() . '/resy_wheelsets_response_1.html';

echo "<h1>Wheelsets Response Analyse</h1>";

if (file_exists($htmlFile)) {
    $html = file_get_contents($htmlFile);
    echo "<p>HTML-Datei gefunden: " . strlen($html) . " bytes</p>";
    
    // Suche nach divs mit Klassen
    if (preg_match_all('/<div[^>]*class="[^"]*"[^>]*>(.*?)<\/div>/s', $html, $divs)) {
        echo "<h2>Gefundene divs mit Klassen: " . count($divs[1]) . "</h2>";
        
        foreach ($divs[1] as $index => $div) {
            echo "<h3>Div " . ($index + 1) . " (Länge: " . strlen($div) . " Zeichen)</h3>";
            
            // Prüfe ob div Reifensatz-relevante Inhalte hat
            $hasLgs = strpos($div, 'LGS') !== false;
            $hasSatznummer = strpos($div, 'Satznummer') !== false;
            $hasKennzeichen = strpos($div, 'Kennzeichen') !== false;
            $hasAnz = strpos($div, 'Anz=') !== false;
            
            if ($hasLgs || $hasSatznummer || $hasKennzeichen || $hasAnz) {
                echo "<p style='color: green;'>✅ Reifensatz-relevanter Inhalt gefunden</p>";
                echo "<p>LGS: " . ($hasLgs ? "✅" : "❌") . " | Satznummer: " . ($hasSatznummer ? "✅" : "❌") . " | Kennzeichen: " . ($hasKennzeichen ? "✅" : "❌") . " | Anz=: " . ($hasAnz ? "✅" : "❌") . "</p>";
                
                // Zeige den Inhalt
                echo "<h4>Div-Inhalt:</h4>";
                echo "<pre>" . htmlspecialchars($div) . "</pre>";
                
                // Suche nach span-Elementen
                if (preg_match_all('/<span[^>]*>(.*?)<\/span>/s', $div, $spans)) {
                    echo "<h4>Gefundene spans: " . count($spans[1]) . "</h4>";
                    foreach ($spans[1] as $spanIndex => $span) {
                        $cleanSpan = trim(strip_tags($span));
                        echo "<p>Span $spanIndex: '" . htmlspecialchars($cleanSpan) . "'</p>";
                    }
                }
                
                // Suche nach input-Elementen
                if (preg_match_all('/<input[^>]*>/s', $div, $inputs)) {
                    echo "<h4>Gefundene inputs: " . count($inputs[1]) . "</h4>";
                    foreach ($inputs[1] as $inputIndex => $input) {
                        echo "<p>Input $inputIndex: " . htmlspecialchars($input) . "</p>";
                    }
                }
                
                // Suche nach select-Elementen
                if (preg_match_all('/<select[^>]*>(.*?)<\/select>/s', $div, $selects)) {
                    echo "<h4>Gefundene selects: " . count($selects[1]) . "</h4>";
                    foreach ($selects[1] as $selectIndex => $select) {
                        echo "<p>Select $selectIndex: " . htmlspecialchars($select) . "</p>";
                    }
                }
            } else {
                echo "<p style='color: gray;'>❌ Kein Reifensatz-relevanter Inhalt</p>";
            }
        }
    } else {
        echo "<p>Keine divs mit Klassen gefunden</p>";
    }
    
    // Suche nach LGS_ID, Satznummer, Kennzeichen in der gesamten HTML
    echo "<h2>Suche nach Schlüsselwörtern in der gesamten HTML:</h2>";
    
    if (preg_match_all('/LGS_ID[^>]*>([^<]+)</', $html, $lgsMatches)) {
        echo "<p>LGS_ID gefunden: " . count($lgsMatches[1]) . "</p>";
        foreach ($lgsMatches[1] as $index => $lgs) {
            echo "<p>LGS $index: '" . htmlspecialchars(trim($lgs)) . "'</p>";
        }
    }
    
    if (preg_match_all('/Satznummer[^>]*>([^<]+)</', $html, $satzMatches)) {
        echo "<p>Satznummer gefunden: " . count($satzMatches[1]) . "</p>";
        foreach ($satzMatches[1] as $index => $satz) {
            echo "<p>Satz $index: '" . htmlspecialchars(trim($satz)) . "'</p>";
        }
    }
    
    if (preg_match_all('/Kennzeichen[^>]*>([^<]+)</', $html, $kennzeichenMatches)) {
        echo "<p>Kennzeichen gefunden: " . count($kennzeichenMatches[1]) . "</p>";
        foreach ($kennzeichenMatches[1] as $index => $kennzeichen) {
            echo "<p>Kennzeichen $index: '" . htmlspecialchars(trim($kennzeichen)) . "'</p>";
        }
    }
    
    if (preg_match_all('/Anz=([^<]+)/', $html, $anzMatches)) {
        echo "<p>Anz= gefunden: " . count($anzMatches[1]) . "</p>";
        foreach ($anzMatches[1] as $index => $anz) {
            echo "<p>Anz $index: '" . htmlspecialchars(trim($anz)) . "'</p>";
        }
    }
    
} else {
    echo "<p style='color: red;'>HTML-Datei nicht gefunden: $htmlFile</p>";
}
?>
