<?php
session_start();

if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    header('Location: login.php');
    exit;
}

require_once dirname(__DIR__) . '/config/database.php';

// Lade Autohäuser
$db = new Database();
$conn = $db->getConnection();
$stmt = $conn->query("SELECT id, name FROM autohaus WHERE is_active = 1 ORDER BY name");
$autohauser = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RESY-Daten Import - Boxenstop Admin</title>
    <link rel="stylesheet" href="assets/css/admin.css">
    <link rel="stylesheet" href="assets/css/unified-sidebar.css">
    <style>
        .import-container {
            max-width: 900px;
            margin: 0 auto;
            padding: var(--space-lg);
        }
        
        .upload-box {
            border: 2px dashed var(--volvo-blue);
            border-radius: var(--radius-md);
            padding: var(--space-xl);
            text-align: center;
            background: var(--volvo-gray-50);
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .upload-box:hover {
            background: var(--volvo-gray-100);
            border-color: var(--volvo-blue-dark);
        }
        
        .import-results {
            margin-top: var(--space-lg);
        }
        
        .result-item {
            padding: var(--space-md);
            background: white;
            border-left: 4px solid var(--volvo-blue);
            margin-bottom: var(--space-sm);
        }
        
        .result-success {
            border-left-color: #28a745;
        }
        
        .result-error {
            border-left-color: #dc3545;
        }
    </style>
</head>
<body>
    <?php include 'includes/sidebar.php'; ?>
    
    <div class="main-content">
        <div class="import-container">
            <h1>📥 RESY-Daten Import</h1>
            <p>Importiere Reifensätze aus dem RESY-System</p>
            
            <div class="upload-box" onclick="document.getElementById('htmlFile').click()">
                <i class="fas fa-upload fa-3x" style="color: var(--volvo-blue); margin-bottom: 20px;"></i>
                <h3>HTML-Datei hochladen</h3>
                <p>Lade die HTML-Datei von RESY hoch</p>
                <input type="file" id="htmlFile" accept=".html" style="display: none;">
            </div>
            
            <div id="results" class="import-results"></div>
            
            <button onclick="triggerPuppeteer()" class="btn btn-primary" style="margin-top: 20px;">
                🤖 Automatischer Import mit Puppeteer
            </button>
        </div>
    </div>
    
    <script>
        document.getElementById('htmlFile').addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                uploadHTML(file);
            }
        });
        
        function uploadHTML(file) {
            const formData = new FormData();
            formData.append('html', file);
            formData.append('autohaus_id', 1);
            
            fetch('../api/import_resy_html.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                showResults(data);
            })
            .catch(error => {
                console.error('Error:', error);
            });
        }
        
        function triggerPuppeteer() {
            fetch('../api/trigger_puppeteer.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ autohaus_id: 1 })
            })
            .then(response => response.json())
            .then(data => {
                showResults(data);
            })
            .catch(error => {
                console.error('Error:', error);
            });
        }
        
        function showResults(data) {
            const resultsDiv = document.getElementById('results');
            resultsDiv.innerHTML = '<h3>Import-Ergebnisse:</h3>';
            
            if (data.success) {
                resultsDiv.innerHTML += `<div class="result-item result-success">
                    ✅ ${data.count} Reifensätze importiert
                </div>`;
            } else {
                resultsDiv.innerHTML += `<div class="result-item result-error">
                    ❌ Fehler: ${data.error}
                </div>`;
            }
        }
    </script>
</body>
</html>

