-- Performance Optimization Indexes for Boxenstop Database
-- Execute these queries to improve database performance

-- Indexes for admin_users table
CREATE INDEX IF NOT EXISTS idx_admin_users_autohaus_id ON admin_users(autohaus_id);
CREATE INDEX IF NOT EXISTS idx_admin_users_role ON admin_users(role);
CREATE INDEX IF NOT EXISTS idx_admin_users_can_switch ON admin_users(can_switch_autohaus);

-- Indexes for events table
CREATE INDEX IF NOT EXISTS idx_events_autohaus_id ON events(autohaus_id);
CREATE INDEX IF NOT EXISTS idx_events_is_active ON events(is_active);
CREATE INDEX IF NOT EXISTS idx_events_event_date ON events(event_date);
CREATE INDEX IF NOT EXISTS idx_events_autohaus_active ON events(autohaus_id, is_active);

-- Indexes for appointments table
CREATE INDEX IF NOT EXISTS idx_appointments_event_id ON appointments(event_id);
CREATE INDEX IF NOT EXISTS idx_appointments_autohaus_id ON appointments(autohaus_id);
CREATE INDEX IF NOT EXISTS idx_appointments_slot_date ON appointments(slot_date);
CREATE INDEX IF NOT EXISTS idx_appointments_status ON appointments(status);
CREATE INDEX IF NOT EXISTS idx_appointments_autohaus_date ON appointments(autohaus_id, slot_date);
CREATE INDEX IF NOT EXISTS idx_appointments_date_status ON appointments(slot_date, status);

-- Indexes for autohaus table
CREATE INDEX IF NOT EXISTS idx_autohaus_is_active ON autohaus(is_active);

-- Composite indexes for common queries
CREATE INDEX IF NOT EXISTS idx_appointments_complex ON appointments(event_id, autohaus_id, slot_date, status);
CREATE INDEX IF NOT EXISTS idx_events_complex ON events(autohaus_id, is_active, event_date);

-- Analyze tables to update statistics
ANALYZE TABLE admin_users;
ANALYZE TABLE events;
ANALYZE TABLE appointments;
ANALYZE TABLE autohaus;