<?php
/**
 * Debug Suspend User API
 * Test the suspend functionality
 */

// Enable error display for debugging
ini_set('display_errors', 1);
error_reporting(E_ALL);

session_start();

echo "=== DEBUG SUSPEND USER API ===\n";

// Check session
echo "Session admin_logged_in: " . (isset($_SESSION['admin_logged_in']) ? 'true' : 'false') . "\n";
echo "Session admin_id: " . (isset($_SESSION['admin_id']) ? $_SESSION['admin_id'] : 'not set') . "\n";

// Test database connection
try {
    require_once '../config/database.php';
    $db = new Database();
    $conn = $db->getConnection();
    echo "✅ Database connection successful\n";
    
    // Test if admin_actions table exists
    $stmt = $conn->query("SHOW TABLES LIKE 'admin_actions'");
    if ($stmt->rowCount() > 0) {
        echo "✅ admin_actions table exists\n";
    } else {
        echo "❌ admin_actions table does not exist\n";
    }
    
    // Test if user_notifications table exists
    $stmt = $conn->query("SHOW TABLES LIKE 'user_notifications'");
    if ($stmt->rowCount() > 0) {
        echo "✅ user_notifications table exists\n";
    } else {
        echo "❌ user_notifications table does not exist\n";
    }
    
    // Test users table
    $stmt = $conn->query("SELECT COUNT(*) as count FROM users");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "✅ Users table accessible, count: " . $result['count'] . "\n";
    
} catch (Exception $e) {
    echo "❌ Database error: " . $e->getMessage() . "\n";
}

echo "=== END DEBUG ===\n";
?>
