# Google Sign-In Setup Anleitung

## Übersicht

Google Sign-In wurde erfolgreich in die Login-Seite integriert. Um es zu aktivieren, müssen Sie eine Google Client ID in der Google Cloud Console erstellen und konfigurieren.

**Wichtig:** Die OAuth 2.0 Credentials können **nicht** vollständig über die Cloud Shell erstellt werden. Die Cloud Shell kann für die API-Aktivierung verwendet werden, aber die Credentials müssen über die Web-UI erstellt werden.

## Schritt-für-Schritt Anleitung

### Schritt 1: Google Cloud Console öffnen und Projekt erstellen/auswählen

1. Öffnen Sie [Google Cloud Console](https://console.cloud.google.com/)
2. Melden Sie sich mit Ihrem Google-Konto an
3. **Projekt auswählen oder erstellen:**
   - Klicken Sie oben auf die Projektauswahl (neben "Google Cloud")
   - Falls Sie ein neues Projekt erstellen möchten:
     - Klicken Sie auf **"NEW PROJECT"**
     - Geben Sie einen Projektnamen ein (z.B. "Boxenstop App")
     - Klicken Sie auf **"CREATE"**
   - Falls Sie ein bestehendes Projekt verwenden möchten:
     - Wählen Sie es aus der Liste aus

### Schritt 4: OAuth Consent Screen konfigurieren (ERFORDERLICH)

**Wichtig:** Dies muss **vor** der Erstellung der OAuth Credentials gemacht werden!

**Schritt 4.1: OAuth Consent Screen öffnen**

1. Klicken Sie im **linken Menü** auf **"APIs & Services"**
2. In dem sich öffnenden Untermenü klicken Sie auf **"OAuth consent screen"**
   - Sie finden es direkt unter "APIs & Services" im linken Menü
   - Falls Sie es nicht sehen, scrollen Sie im Menü nach unten

**Schritt 4.2: User Type auswählen**

3. Sie sehen jetzt eine Seite mit der Überschrift "OAuth consent screen"
4. Wählen Sie den **User Type**:
   - **Klicken Sie auf "External"** (für öffentliche Nutzer) - empfohlen für die meisten Anwendungen
   - **"Internal"** ist nur für Google Workspace Organisationen verfügbar
5. Nach der Auswahl klicken Sie auf **"CREATE"** (blauer Button unten rechts)

**Schritt 4.3: App-Informationen ausfüllen**

6. Sie sehen jetzt ein Formular mit mehreren Feldern:

   **Pflichtfelder (mit rotem Stern):**

   - **App name:** Geben Sie `Boxenstop` ein (oder Ihren gewünschten App-Namen)
   - **User support email:**
     - Klicken Sie auf das Dropdown-Feld
     - Wählen Sie Ihre E-Mail-Adresse aus (die mit Ihrem Google-Konto verbunden ist)

   **Optional (aber empfohlen):**

   - **App logo:** Klicken Sie auf "UPLOAD" um ein Logo hochzuladen (kann später gemacht werden)
   - **App domain:** Geben Sie `be-automobileapps.de` ein
   - **Application home page:** `https://be-automobileapps.de`
   - **Application privacy policy link:** Optional (kann später hinzugefügt werden)
   - **Application terms of service link:** Optional (kann später hinzugefügt werden)
   - **Authorized domains:** `be-automobileapps.de` (wird automatisch hinzugefügt, wenn Sie die App domain eingeben)
   - **Developer contact information:** Ihre E-Mail-Adresse (wird automatisch aus Ihrem Google-Konto übernommen)

7. Scrollen Sie nach unten und klicken Sie auf **"SAVE AND CONTINUE"** (blauer Button)

**Schritt 4.4: Scopes konfigurieren**

8. Sie sehen jetzt die Seite "Scopes"
9. Für Google Sign-In sind die **Standard-Scopes bereits ausgewählt**:
   - `.../auth/userinfo.email` (E-Mail-Adresse abrufen)
   - `.../auth/userinfo.profile` (Basis-Profilinformationen abrufen)
   - `openid` (OpenID Connect)
10. **Sie müssen nichts ändern!** Klicken Sie direkt auf **"SAVE AND CONTINUE"**

**Schritt 4.5: Test users (optional)**

11. Sie sehen jetzt die Seite "Test users"
12. **Für den Anfang können Sie diesen Schritt überspringen:**
    - Klicken Sie auf **"SAVE AND CONTINUE"**
    - Oder fügen Sie Test-User hinzu, wenn Sie die App noch nicht verifiziert haben:
      - Klicken Sie auf **"+ ADD USERS"**
      - Geben Sie die E-Mail-Adressen von Test-Usern ein
      - Klicken Sie auf **"ADD"**

**Schritt 4.6: Zusammenfassung**

13. Sie sehen jetzt eine Zusammenfassung
14. Klicken Sie auf **"BACK TO DASHBOARD"** (oder "DASHBOARD" im linken Menü)

**✅ OAuth Consent Screen ist jetzt konfiguriert! Weiter geht's mit der Client ID Erstellung.**

### Schritt 3: Identity Toolkit API aktivieren

**Sie haben die Identity Toolkit API bereits gefunden! Jetzt aktivieren Sie sie:**

1. **Auf der Identity Toolkit API Seite:**

   - Sie sollten eine große blaue Schaltfläche **"ENABLE"** sehen
   - Klicken Sie auf **"ENABLE"**
   - Warten Sie einige Sekunden, bis die Aktivierung abgeschlossen ist
   - Sie sehen dann eine grüne Meldung "API enabled" oder "API aktiviert"

2. **Nach der Aktivierung:**
   - Sie können auf **"MANAGE"** klicken, um zur Übersicht zu gehen
   - Oder Sie gehen direkt weiter zu Schritt 4

**✅ Gut gemacht! Die API ist jetzt aktiviert. Weiter geht's mit dem OAuth Consent Screen.**

### Schritt 5: OAuth 2.0 Client ID erstellen (NUR über Web-UI möglich)

**Wichtig:** Dies kann **nicht** über die Cloud Shell gemacht werden!

**Schritt 5.1: Credentials-Seite öffnen**

1. Klicken Sie im **linken Menü** auf **"APIs & Services"**
2. Klicken Sie auf **"Credentials"** (im Untermenü unter "APIs & Services")
3. Sie sehen jetzt eine Seite mit der Überschrift "Credentials"

**Schritt 5.2: OAuth Client ID erstellen**

4. Oben auf der Seite sehen Sie einen Button **"+ CREATE CREDENTIALS"**
5. Klicken Sie auf **"+ CREATE CREDENTIALS"**
6. Ein Dropdown-Menü öffnet sich mit folgenden Optionen:
   - API key
   - OAuth client ID ← **DIESES WÄHLEN SIE!**
   - Service account
   - etc.
7. Klicken Sie auf **"OAuth client ID"**

**Schritt 5.3: Application Type auswählen**

8. Ein neues Fenster/Modal öffnet sich mit dem Titel "Create OAuth client ID"
9. Falls Sie noch keinen OAuth Consent Screen konfiguriert haben, sehen Sie eine Warnung:

   - **In diesem Fall:** Gehen Sie zurück zu Schritt 4 und konfigurieren Sie den OAuth Consent Screen zuerst!
   - **Falls bereits konfiguriert:** Sie sehen ein Formular

10. **Application type auswählen:**
    - Sie sehen ein Dropdown-Feld "Application type"
    - Klicken Sie darauf und wählen Sie **"Web application"** aus

**Schritt 5.4: Name und URIs konfigurieren**

11. **Name eingeben:**

    - Direkt unter "Application type" sehen Sie das Feld "Name"
    - Geben Sie ein: `Boxenstop Web Client` (oder einen anderen Namen Ihrer Wahl)

12. **Authorized JavaScript origins hinzufügen:**

    - Scrollen Sie nach unten zu "Authorized JavaScript origins"
    - Klicken Sie auf **"+ ADD URI"** (Button)
    - Ein Textfeld erscheint
    - Geben Sie ein: `https://be-automobileapps.de`
    - Klicken Sie erneut auf **"+ ADD URI"** für eine weitere Zeile
    - Geben Sie ein: `http://localhost` (für lokale Entwicklung)
    - **Wichtig:** Keine Leerzeichen, keine abschließenden Slashes (/) außer bei localhost

13. **Authorized redirect URIs (optional):**
    - Scrollen Sie weiter zu "Authorized redirect URIs"
    - Für Google Sign-In mit Popup sind Redirect URIs **nicht zwingend erforderlich**
    - Sie können diesen Abschnitt leer lassen
    - ODER fügen Sie hinzu (falls Sie später einen Callback-Endpoint benötigen):
      - Klicken Sie auf **"+ ADD URI"**
      - Geben Sie ein: `https://be-automobileapps.de/api/google_callback.php`

**Schritt 5.5: Client ID erstellen**

14. Klicken Sie auf **"CREATE"** (blauer Button unten rechts)

15. **WICHTIG - Client ID kopieren:**

    - Ein neues Fenster/Modal öffnet sich mit dem Titel "OAuth client created"
    - Sie sehen zwei wichtige Informationen:
      - **Your Client ID:** Beginnt mit `xxxxx.apps.googleusercontent.com`
      - **Your Client Secret:** Ein langer String (wird nur EINMAL angezeigt!)

    **Was Sie jetzt tun müssen:**

    - **Kopieren Sie die Client ID:**

      - Markieren Sie den gesamten Text (z.B. `123456789-abcdefghijklmnop.apps.googleusercontent.com`)
      - Drücken Sie `Strg + C` (Windows) oder `Cmd + C` (Mac)
      - Oder klicken Sie auf das kleine Kopier-Symbol neben dem Text (falls vorhanden)
      - **Speichern Sie die Client ID in einer Textdatei oder Notizen!**

    - **Client Secret (optional):**
      - Das Client Secret benötigen Sie für Google Sign-In **nicht** (nur die Client ID)
      - Sie können es trotzdem kopieren und sicher speichern, falls Sie es später brauchen

16. Klicken Sie auf **"OK"** um das Fenster zu schließen

**✅ Client ID wurde erstellt! Sie sehen sie jetzt in der Credentials-Liste.**

### Schritt 6: Client ID in login.php eintragen

**Jetzt müssen Sie die kopierte Client ID in Ihre `login.php` Datei einfügen:**

1. **Öffnen Sie die Datei `login.php`** in Ihrem Editor (z.B. Visual Studio Code, Notepad++, etc.)

2. **Suchen Sie nach der Zeile mit GOOGLE_CLIENT_ID:**

   - Drücken Sie `Strg + F` (Windows) oder `Cmd + F` (Mac) für die Suche
   - Geben Sie ein: `GOOGLE_CLIENT_ID`
   - Die Zeile sollte etwa so aussehen (ca. Zeile 1168):
     ```javascript
     const GOOGLE_CLIENT_ID =
       "YOUR_GOOGLE_CLIENT_ID.apps.googleusercontent.com";
     ```

3. **Ersetzen Sie den Platzhalter:**

   - Markieren Sie den Text zwischen den Anführungszeichen: `YOUR_GOOGLE_CLIENT_ID.apps.googleusercontent.com`
   - Löschen Sie ihn
   - Fügen Sie Ihre kopierte Client ID ein (z.B. mit `Strg + V` oder `Cmd + V`)

   **Das Ergebnis sollte so aussehen:**

   ```javascript
   const GOOGLE_CLIENT_ID =
     "123456789-abcdefghijklmnop.apps.googleusercontent.com";
   ```

   **Wichtig:**

   - Behalten Sie die Anführungszeichen!
   - Keine Leerzeichen vor oder nach der Client ID
   - Die Client ID muss genau so aussehen wie in der Google Cloud Console

4. **Speichern Sie die Datei:**
   - Drücken Sie `Strg + S` (Windows) oder `Cmd + S` (Mac)
   - Oder klicken Sie auf "Save" im Menü

**✅ Client ID wurde erfolgreich eingetragen!**

### Schritt 7: Datenbank-Migration ausführen

Führen Sie die SQL-Migration aus, um die `google_user_id` Spalte zur `users`-Tabelle hinzuzufügen:

**Option A: Über phpMyAdmin oder MySQL Workbench**

```sql
ALTER TABLE users
ADD COLUMN IF NOT EXISTS google_user_id VARCHAR(255) NULL UNIQUE AFTER apple_user_id;

CREATE INDEX IF NOT EXISTS idx_google_user_id ON users(google_user_id);
```

**Option B: Über die Kommandozeile**

```bash
mysql -u your_username -p your_database < database/add_google_user_id.sql
```

**Option C: Falls `IF NOT EXISTS` nicht unterstützt wird (MySQL < 5.7):**

```sql
-- Prüfe ob Spalte existiert, falls nicht, füge sie hinzu
SET @dbname = DATABASE();
SET @tablename = "users";
SET @columnname = "google_user_id";
SET @preparedStatement = (SELECT IF(
  (
    SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
    WHERE
      (table_name = @tablename)
      AND (table_schema = @dbname)
      AND (column_name = @columnname)
  ) > 0,
  "SELECT 'Column already exists.'",
  CONCAT("ALTER TABLE ", @tablename, " ADD COLUMN ", @columnname, " VARCHAR(255) NULL UNIQUE AFTER apple_user_id")
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

-- Index erstellen (falls nicht vorhanden)
CREATE INDEX IF NOT EXISTS idx_google_user_id ON users(google_user_id);
```

## Cloud Shell vs. Web-UI - Was geht wo?

### ✅ Über Cloud Shell möglich:

- API-Aktivierung:
  ```bash
  gcloud services enable identitytoolkit.googleapis.com
  ```
- Projekt-Informationen anzeigen:
  ```bash
  gcloud config get-value project
  ```
- API-Status prüfen:
  ```bash
  gcloud services list --enabled
  ```

### ❌ Nur über Web-UI möglich:

- OAuth Consent Screen konfigurieren
- OAuth 2.0 Client ID erstellen
- Authorized JavaScript origins hinzufügen
- Authorized redirect URIs konfigurieren
- Client ID und Client Secret anzeigen/kopieren

**Fazit:** Die Cloud Shell ist nützlich für API-Aktivierungen, aber die OAuth Credentials müssen über die Web-UI erstellt werden.

## Funktionalität

### Features

- ✅ Google Sign-In mit Popup
- ✅ Automatische Registrierung für neue Nutzer
- ✅ Automatisches Login für bestehende Nutzer
- ✅ Verknüpfung mit bestehenden E-Mail-Konten
- ✅ Datenschutz-Checkbox-Integration
- ✅ Google Logo mit vier Farben (blau, rot, gelb, grün)
- ✅ Unterstützung für "Anmelden" und "Registrieren"

### Verhalten

- **Neue Nutzer**: Werden automatisch registriert und erhalten den Status "pending" (müssen verifiziert werden)
- **Bestehende Nutzer**: Werden automatisch eingeloggt
- **E-Mail-Verknüpfung**: Wenn eine E-Mail bereits existiert, wird das Google-Konto automatisch verknüpft

## Technische Details

### Frontend

- Verwendet Google Identity Services (GIS) SDK
- OAuth 2.0 mit Popup-Flow
- Automatisches Abrufen von User-Info über Google API

### Backend

- Erweitert `api/login_user.php` um Google Sign-In Support
- Speichert `google_user_id` in der Datenbank
- Unterstützt automatische Registrierung und Login

## Troubleshooting

### "Google Sign-In wird geladen..." erscheint ständig

- Überprüfen Sie, ob die Google Client ID korrekt eingetragen ist
- Überprüfen Sie die Browser-Konsole auf Fehler
- Stellen Sie sicher, dass die Google SDK geladen wurde

### "Invalid client" Fehler

- Überprüfen Sie die Client ID in `login.php`
- Stellen Sie sicher, dass die autorisierten JavaScript-Ursprünge in Google Cloud Console korrekt sind

### Popup wird blockiert

- Überprüfen Sie die Browser-Popup-Einstellungen
- Stellen Sie sicher, dass die Domain in den autorisierten Ursprüngen enthalten ist

## Sicherheit

- Die Google Client ID ist öffentlich sichtbar (das ist normal und sicher)
- Die eigentliche Authentifizierung erfolgt über OAuth 2.0
- Access Tokens werden nur client-seitig verwendet und nicht gespeichert
- User-Informationen werden sicher über HTTPS übertragen
