<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Test Detailseite</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 800px;
            margin: 50px auto;
            padding: 20px;
            background: #f5f5f5;
        }
        .container {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }
        h1 {
            color: #2c3e50;
            text-align: center;
            margin-bottom: 30px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
            color: #34495e;
        }
        input[type="text"] {
            width: 100%;
            padding: 12px;
            border: 2px solid #ddd;
            border-radius: 5px;
            font-size: 16px;
        }
        button {
            background: #3498db;
            color: white;
            padding: 12px 30px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            width: 100%;
        }
        button:hover {
            background: #2980b9;
        }
        .result {
            margin-top: 30px;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 5px;
            border-left: 4px solid #3498db;
        }
        .links {
            margin-top: 20px;
        }
        .links a {
            display: inline-block;
            margin: 10px 10px 10px 0;
            padding: 10px 20px;
            background: #27ae60;
            color: white;
            text-decoration: none;
            border-radius: 5px;
        }
        .links a:hover {
            background: #229954;
        }
        .links a.resy {
            background: #e74c3c;
        }
        .links a.resy:hover {
            background: #c0392b;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 Detailseite Test</h1>
        
        <form method="GET">
            <div class="form-group">
                <label for="lgs_id">Einlagerungsnummer (LGS-ID):</label>
                <input type="text" id="lgs_id" name="lgs_id" 
                       value="<?php echo htmlspecialchars($_GET['lgs_id'] ?? '9.716.991'); ?>" 
                       placeholder="z.B. 9.716.991">
            </div>
            <button type="submit">Daten abrufen</button>
        </form>
        
        <?php if (isset($_GET['lgs_id']) && !empty($_GET['lgs_id'])): ?>
            <div class="result">
                <h3>📋 Ergebnis für Einlagerungsnummer: <?php echo htmlspecialchars($_GET['lgs_id']); ?></h3>
                
                <?php
                try {
                    // API aufrufen
                    $apiUrl = 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']) . '/api/check_tire_status.php';
                    
                    $postData = json_encode([
                        'storage_number' => $_GET['lgs_id'],
                        'appointment_date' => '',
                        'event_name' => ''
                    ]);
                    
                    $ch = curl_init();
                    curl_setopt_array($ch, [
                        CURLOPT_URL => $apiUrl,
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_POST => true,
                        CURLOPT_POSTFIELDS => $postData,
                        CURLOPT_HTTPHEADER => [
                            'Content-Type: application/json',
                            'Content-Length: ' . strlen($postData)
                        ],
                        CURLOPT_TIMEOUT => 30
                    ]);
                    
                    $response = curl_exec($ch);
                    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                    curl_close($ch);
                    
                    if ($httpCode === 200 && $response) {
                        $result = json_decode($response, true);
                        
                        if ($result && $result['success']) {
                            echo '<p style="color: green;">✅ Daten erfolgreich abgerufen!</p>';
                            
                            // Links anzeigen
                            echo '<div class="links">';
                            if (isset($result['local_detail_link'])) {
                                echo '<a href="' . htmlspecialchars($result['local_detail_link']) . '" target="_blank">';
                                echo '🔗 Lokale Detailseite öffnen';
                                echo '</a>';
                            }
                            if (isset($result['detail_link'])) {
                                echo '<a href="' . htmlspecialchars($result['detail_link']) . '" target="_blank" class="resy">';
                                echo '🌐 Resy-Detailseite öffnen';
                                echo '</a>';
                            }
                            echo '</div>';
                            
                            // Kurze Datenübersicht
                            $data = $result['data'];
                            echo '<h4>📊 Kurze Übersicht:</h4>';
                            echo '<ul>';
                            echo '<li><strong>Einlagerungsnummer:</strong> ' . htmlspecialchars($data['einlagerungsnummer'] ?? 'N/A') . '</li>';
                            echo '<li><strong>Kennzeichen:</strong> ' . htmlspecialchars($data['kennzeichen'] ?? 'N/A') . '</li>';
                            echo '<li><strong>Haltername:</strong> ' . htmlspecialchars($data['haltername'] ?? 'N/A') . '</li>';
                            echo '<li><strong>Fahrzeugtyp:</strong> ' . htmlspecialchars($data['fahrzeugtyp'] ?? 'N/A') . '</li>';
                            echo '</ul>';
                            
                        } else {
                            echo '<p style="color: red;">❌ Fehler: ' . htmlspecialchars($result['error'] ?? 'Unbekannter Fehler') . '</p>';
                        }
                    } else {
                        echo '<p style="color: red;">❌ API-Fehler: HTTP ' . $httpCode . '</p>';
                    }
                    
                } catch (Exception $e) {
                    echo '<p style="color: red;">❌ Fehler: ' . htmlspecialchars($e->getMessage()) . '</p>';
                }
                ?>
            </div>
        <?php endif; ?>
        
        <div style="margin-top: 40px; padding: 20px; background: #ecf0f1; border-radius: 5px;">
            <h4>ℹ️ Verwendung:</h4>
            <ul>
                <li>Gib eine gültige Einlagerungsnummer ein (z.B. 9.716.991)</li>
                <li>Klicke auf "Daten abrufen" um die API zu testen</li>
                <li>Verwende die Links um die Detailseiten zu öffnen</li>
                <li>Die lokale Detailseite zeigt alle Daten übersichtlich an</li>
                <li>Die Resy-Detailseite führt direkt zum Resy-System</li>
            </ul>
        </div>
    </div>
</body>
</html>




