<?php
echo "<h1>Debug Login Test</h1>";

// Simuliere den API-Aufruf
$_SERVER['REQUEST_METHOD'] = 'POST';
$_SERVER['CONTENT_TYPE'] = 'application/json';

$testData = json_encode(['action' => 'login', 'appointment_id' => 89]);

// Temporäre Datei für Input
$tempFile = tempnam(sys_get_temp_dir(), 'resy_input');
file_put_contents($tempFile, $testData);

// Simuliere php://input
$originalInput = 'php://input';
$mockInput = $tempFile;

echo "<h2>Test Debug Login API</h2>";
echo "<pre>";
echo "Input: " . $testData . "\n\n";

// Include der Debug-API
ob_start();
include 'api/resy_data_extraction_debug_login.php';
$output = ob_get_clean();

echo "Output: " . $output . "\n\n";

$decoded = json_decode($output, true);
if ($decoded) {
    echo "Decoded JSON:\n";
    print_r($decoded);
} else {
    echo "JSON Decode Error: " . json_last_error_msg() . "\n";
}
echo "</pre>";

// Cleanup
unlink($tempFile);

echo "<h2>Log-Datei (letzte 20 Zeilen)</h2>";
echo "<pre>";
if (file_exists('logs/resy_extraction.log')) {
    $lines = file('logs/resy_extraction.log');
    $lastLines = array_slice($lines, -20);
    echo implode('', $lastLines);
} else {
    echo "Log-Datei nicht gefunden.";
}
echo "</pre>";
?>
