<?php
// CLI only
if (php_sapi_name() !== 'cli') { echo "CLI only\n"; exit(1); }

$api_key = '306426e96ccc208c97ff49dc51d85558';
$base_url = 'http://localhost/boxenstop';

// Alle relevanten API-Endpunkte
$endpoints = [
    // Public/Settings
    'settings.php' => ['method' => 'GET'],
    'get_available_slots.php?event_id=21&date=2025-10-31' => ['method' => 'GET'],
    'autohaus_selection.php' => ['method' => 'POST', 'body' => json_encode(['action' => 'test'])],
    
    // Profile/User
    'get_user_profile.php' => ['method' => 'GET'],
    'update_profile.php' => ['method' => 'POST', 'body' => json_encode(['first_name' => 'Test'])],
    'get_user_notifications.php' => ['method' => 'GET'],
    'get_activity_log.php' => ['method' => 'GET'],
    
    // Vehicles
    'get_vehicle.php?id=1' => ['method' => 'GET'],
    'add_vehicle.php' => ['method' => 'POST', 'body' => json_encode(['license_plate' => 'TEST'])],
    'update_vehicle.php' => ['method' => 'POST', 'body' => json_encode(['vehicle_id' => 1])],
    
    // Appointments
    'appointments.php' => ['method' => 'POST', 'body' => json_encode(['event_id' => 21, 'slot_date' => '2025-10-31', 'customer_name' => 'Test'])],
    'cancel_appointment.php' => ['method' => 'POST', 'body' => json_encode(['appointment_id' => 999])],
    
    // Tire/Offer APIs
    'get_autohauser.php' => ['method' => 'GET'],
    'get_autohaus_services.php?autohaus_id=1' => ['method' => 'GET'],
    'get_offer_details.php?appointmentId=999' => ['method' => 'GET'],
    'get_customer_selection.php?appointmentId=999' => ['method' => 'GET'],
    'get_tire_suggestions.php?appointmentId=999' => ['method' => 'GET'],
    'get_smtp_data.php?appointmentId=999' => ['method' => 'GET'],
    
    // RESY/Image
    'resy_image_proxy.php?lgfoto_id=test' => ['method' => 'GET'],
    
    // PDF
    'view_pdf.php?filename=test.pdf' => ['method' => 'GET'],
    'download_pdf.php?filename=test.pdf' => ['method' => 'GET'],
    
    // Teams/Email
    'send_teams_notification.php' => ['method' => 'POST', 'body' => json_encode(['message' => 'test'])],
    
    // Storage
    'get_stored_wheelsets_clean.php' => ['method' => 'GET'],
];

echo "API-Key Test – ALLE Endpunkte\n";
echo "API Key: {$api_key}\n";
echo "====================================\n\n";

$count = 0;
foreach ($endpoints as $endpoint => $config) {
    $count++;
    $url = $base_url . '/api/' . $endpoint;
    
    $ch = curl_init();
    $headers = ['Content-Type: application/json', "X-Api-Key: {$api_key}"];
    
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_CUSTOMREQUEST => $config['method'],
    ]);
    
    if ($config['method'] === 'POST' && isset($config['body'])) {
        curl_setopt($ch, CURLOPT_POSTFIELDS, $config['body']);
    }
    
    curl_exec($ch);
    $status = curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
    curl_close($ch);
    
    $icon = in_array($status, [200, 201, 400, 401, 403, 404, 500], true) ? '✅' : '⚠️';
    echo sprintf("%s [%d/%d] %s → %d\n", $icon, $count, count($endpoints), $endpoint, $status);
    
    // Kurze Pause um Server nicht zu überlasten
    usleep(100000); // 100ms
}

echo "\n====================================\n";
echo "✅ Alle Tests abgeschlossen!\n";
echo "→ Überprüfe nun admin/api_manager.php → API Nutzung & Monitoring\n";
?>

