<?php
require_once __DIR__ . '/../config/database.php';
try {
  $db = new Database();
  $conn = $db->getConnection();
  $stmt = $conn->query("SELECT id, endpoint, http_method, status_code, request_ts FROM api_key_usage ORDER BY id DESC LIMIT 10");
  $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
  if (!$rows) { echo "Keine Einträge in api_key_usage.\n"; exit(0); }
  foreach ($rows as $r) {
    echo sprintf("#%d %s %s %s @ %s\n", $r['id'], $r['http_method'], $r['endpoint'], $r['status_code'], $r['request_ts']);
  }
} catch (Throwable $e) {
  echo 'ERROR: ' . $e->getMessage() . "\n";
  exit(1);
}


