<?php
/**
 * Test-Script für die verbesserte RESY-Session-Verwaltung
 */

require_once 'api/resy_data_extraction_breakthrough.php';

echo "=== RESY SESSION MANAGEMENT TEST ===\n";

// Test-Konfiguration
$testConfig = [
    'base_url' => 'https://resy.dtm-reifen.de',
    'username' => 'D.ULUDAG',
    'password' => 'Ikizler123!',
    'test_lgs_id' => '9877038'
];

echo "Base URL: " . $testConfig['base_url'] . "\n";
echo "Test LGS_ID: " . $testConfig['test_lgs_id'] . "\n\n";

try {
    // Test 1: Session-Validierung ohne Login
    echo "--- Test 1: Session-Validierung ohne Login ---\n";
    $sessionValid = validateResySession($testConfig['base_url']);
    echo "Session gültig: " . ($sessionValid ? 'Ja' : 'Nein') . "\n\n";
    
    // Test 2: Login durchführen
    echo "--- Test 2: Login durchführen ---\n";
    $loginResult = performBreakthroughLogin($testConfig['base_url'], $testConfig['username'], $testConfig['password']);
    echo "Login erfolgreich: Ja\n";
    echo "Response Code: " . $loginResult['http_code'] . "\n\n";
    
    // Test 3: Session-Validierung nach Login
    echo "--- Test 3: Session-Validierung nach Login ---\n";
    $sessionValid = validateResySession($testConfig['base_url']);
    echo "Session gültig: " . ($sessionValid ? 'Ja' : 'Nein') . "\n\n";
    
    if ($sessionValid) {
        // Test 4: Suche mit gültiger Session
        echo "--- Test 4: Suche mit gültiger Session ---\n";
        try {
            $searchResult = searchWithUpdatedResySystem($testConfig['base_url'], $testConfig['test_lgs_id']);
            echo "✅ Suche erfolgreich!\n";
            echo "Gefundene LGS_ID: " . $searchResult['lgs_id'] . "\n";
            echo "Suchstrategie: " . $searchResult['search_type'] . "\n";
            echo "Suchbegriff: " . $searchResult['search_term'] . "\n";
        } catch (Exception $e) {
            echo "❌ Suche fehlgeschlagen: " . $e->getMessage() . "\n";
        }
    } else {
        echo "❌ Session nach Login immer noch ungültig\n";
    }
    
} catch (Exception $e) {
    echo "❌ Test fehlgeschlagen: " . $e->getMessage() . "\n";
}

echo "\n=== TEST ABGESCHLOSSEN ===\n";
echo "Prüfen Sie die Logs in: logs/resy_extraction.log\n";
echo "Prüfen Sie die HTML-Dateien in: " . sys_get_temp_dir() . "/\n";
?>
