<?php
/**
 * Test ob Selenium verfügbar ist
 */

require_once 'api/resy_selenium_simple.php';

echo "🧪 Teste Selenium-Verfügbarkeit...\n";
echo str_repeat("=", 60) . "\n\n";

// 1. isAvailable() prüfen
echo "[1/2] Prüfe isAvailable()...\n";
$available = ResySeleniumDriver::isAvailable();
echo ($available ? "✅" : "❌") . " Selenium verfügbar: " . ($available ? "JA" : "NEIN") . "\n\n";

if (!$available) {
    echo "\n❌ PROBLEM: Selenium nicht verfügbar!\n";
    echo "Mögliche Ursachen:\n";
    echo "- Docker Container nicht erreichbar\n";
    echo "- Port 4444 blockiert\n";
    echo "- Selenium nicht gestartet\n";
    exit;
}

// 2. Direkter Test
echo "[2/2] Teste direkte Verbindung...\n";
$ch = curl_init('http://localhost:4444/wd/hub/status');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 5);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: $httpCode\n";
echo ($httpCode === 200 ? "✅" : "❌") . " Direkte Verbindung: " . ($httpCode === 200 ? "ERFOLGREICH" : "FEHLGESCHLAGEN") . "\n";

if ($httpCode === 200) {
    $data = json_decode($response, true);
    echo "Selenium bereit: " . ($data['value']['ready'] ? 'JA' : 'NEIN') . "\n";
}

echo "\n" . str_repeat("=", 60) . "\n";

