<?php
require_once __DIR__ . '/config/database.php';

// Lade Playwright-Daten
$script = __DIR__ . '/resy_playwright.js';
$command = "node \"$script\" 2>&1";

echo "🔄 Lade RESY-Daten via Playwright...\n";
$output = shell_exec($command);

// Parse JSON
$lines = explode("\n", $output);
$result = null;
foreach ($lines as $line) {
    if (strpos($line, '{"success":') !== false) {
        $result = json_decode($line, true);
        break;
    }
}

if (!$result || !$result['success']) {
    echo "❌ Keine Daten von Playwright erhalten\n";
    exit(1);
}

echo "✅ " . count($result['wheelsets']) . " Reifensätze geladen\n\n";

// Speichere in Datenbank
try {
    $host = 'localhost';
    $dbname = 'boxxenstopp';
    $username = 'Admin50';
    $password = 'Ikizler123!';
    
    $dsn = "mysql:host=$host;dbname=$dbname;charset=utf8mb4";
    $pdo = new PDO($dsn, $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
           // Lösche alte Daten für Autohaus 1
           $stmt = $pdo->prepare("DELETE FROM stored_wheelsets_v2 WHERE autohaus_id = 1");
           $stmt->execute();
    
    $stmt = $pdo->prepare("
        INSERT INTO stored_wheelsets_v2 
        (autohaus_id, satznummer, haltername, kennzeichen, fin, autohaus, ziel_autohaus, 
         eingangsdatum, rueckliefertermin, pruefbericht, reifenmodell, reifenart, saison, 
         reifengroesse, lagerplatz, profiltiefe, empfehlung, rueckgabe_bemerkung, status, created_at, updated_at)
        VALUES (1, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'gelagert', NOW(), NOW())
    ");
    
    $count = 0;
    foreach ($result['wheelsets'] as $ws) {
        $stmt->execute([
            $ws['satznummer'] ?? '',
            $ws['haltername'] ?? '',
            $ws['kennzeichen'] ?? '',
            $ws['fin'] ?? '',
            $ws['autohaus'] ?? '',
            $ws['ziel_autohaus'] ?? '',
            $ws['eingangsdatum'] ?? '',
            $ws['rueckliefertermin'] ?? '',
            $ws['pruefbericht'] ?? '',
            $ws['reifenmodell'] ?? '',
            $ws['reifenart'] ?? '',
            $ws['saison'] ?? '',
            $ws['reifengroesse'] ?? '',
            $ws['lagerplatz'] ?? '',
            $ws['profiltiefe'] ?? '',
            $ws['empfehlung'] ?? '',
            $ws['rueckgabe_bemerkung'] ?? ''
        ]);
        $count++;
        
        if ($count <= 5) {
            echo "💾 Gespeichert: " . $ws['kennzeichen'] . " - " . $ws['haltername'] . "\n";
        }
    }
    
    echo "\n✅ $count Reifensätze in der Datenbank gespeichert!\n";
    
} catch (Exception $e) {
    echo "❌ Fehler: " . $e->getMessage() . "\n";
    exit(1);
}

