<?php
/**
 * Direkter Test für RESY mit Selenium
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "🧪 RESY Selenium Direkt-Test\n";
echo str_repeat("=", 60) . "\n\n";

require_once __DIR__ . '/api/resy_selenium_simple.php';

try {
    // 1. Prüfe Selenium-Verfügbarkeit
    echo "[1/5] Prüfe Selenium-Verbindung...\n";
    if (!ResySeleniumDriver::isAvailable()) {
        die("❌ Selenium nicht erreichbar!\n");
    }
    echo "✅ Selenium läuft\n\n";
    
    // 2. Lade Credentials
    echo "[2/5] Lade Autohaus-Daten...\n";
    require_once __DIR__ . '/config/database.php';
    $db = new Database();
    $pdo = $db->getConnection();
    
    $stmt = $pdo->prepare("SELECT name, resy_username, resy_password FROM autohaus WHERE id = 1");
    $stmt->execute();
    $autohaus = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$autohaus || !$autohaus['resy_username']) {
        die("❌ Keine Credentials gefunden!\n");
    }
    
    echo "Autohaus: " . $autohaus['name'] . "\n";
    echo "Username: " . $autohaus['resy_username'] . "\n\n";
    
    // Mapping
    $mapping = [
        'B & E Volvo Kiel' => '453',
        'B & E Volvo Norderstedt' => '452',
        'B & E Volvo Glinde' => '454'
    ];
    $dealerId = $mapping[$autohaus['name']] ?? '453';
    
    echo "[3/5] Starte Selenium-Session...\n";
    echo "Dealer ID: $dealerId\n";
    
    // 3. Starte Selenium
    $driver = new ResySeleniumDriver(
        $autohaus['resy_username'],
        $autohaus['resy_password'],
        $dealerId
    );
    
    echo "✅ Driver erstellt\n\n";
    
    // 4. Login
    echo "[4/5] Versuche Login...\n";
    if ($driver->login()) {
        echo "✅ Login erfolgreich!\n\n";
        
        // 5. Lade Daten
        echo "[5/5] Lade Reifensätze...\n";
        $html = $driver->loadWheelsets();
        
        if ($html && strlen($html) > 100) {
            echo "✅ HTML erhalten: " . strlen($html) . " Bytes\n";
            echo "Erste 200 Zeichen:\n";
            echo substr($html, 0, 200) . "...\n\n";
            
            // Parse HTML
            libxml_use_internal_errors(true);
            $dom = new DOMDocument();
            $dom->loadHTML($html);
            $xpath = new DOMXPath($dom);
            
            $rows = $xpath->query('//tr');
            echo "Zeilen gefunden: " . $rows->length . "\n\n";
            
            $wheelsets = [];
            foreach ($rows as $row) {
                $cells = $xpath->query('./td', $row);
                if ($cells->length >= 2) {
                    $kennzeichen = trim($cells->item(0)->textContent ?? '');
                    if (strlen($kennzeichen) >= 2 && strlen($kennzeichen) <= 20) {
                        $wheelsets[] = [
                            'kennzeichen' => $kennzeichen,
                            'satznummer' => trim($cells->item(1)->textContent ?? '')
                        ];
                    }
                }
            }
            
            echo "\n✅ Reifensätze extrahiert: " . count($wheelsets) . "\n\n";
            
            if (count($wheelsets) > 0) {
                echo "Erste 10:\n";
                foreach (array_slice($wheelsets, 0, 10) as $i => $ws) {
                    echo "  " . ($i+1) . ". " . $ws['kennzeichen'] . " - " . $ws['satznummer'] . "\n";
                }
            } else {
                echo "⚠️ Keine Reifensätze gefunden in HTML\n";
                echo "Speichere HTML für Analyse...\n";
                file_put_contents('temp/resy_html_debug_' . time() . '.html', $html);
                echo "Gespeichert in temp/\n";
            }
            
        } else {
            echo "❌ Kein HTML erhalten\n";
        }
        
        $driver->close();
        echo "\n✅ Session beendet\n";
        
    } else {
        echo "❌ Login fehlgeschlagen!\n";
        $driver->close();
    }
    
} catch (Exception $e) {
    echo "❌ FEHLER: " . $e->getMessage() . "\n";
    echo "Stack:\n" . $e->getTraceAsString() . "\n";
}

echo "\n" . str_repeat("=", 60) . "\n";
echo "✅ Test abgeschlossen\n";

