<?php
/**
 * Test-Script für RESY REST API Integration
 */

require_once 'config/database.php';
require_once 'api/get_resy_wheelsets.php';

header('Content-Type: text/html; charset=utf-8');

echo "<h1>RESY REST API Test</h1>";

try {
    $autohausId = $_GET['autohaus_id'] ?? 1;
    
    echo "<p>Teste mit Autohaus ID: {$autohausId}</p>";
    
    $api = new ResyRestAPI($autohausId);
    $result = $api->getAllWheelsets();
    
    echo "<h2>Ergebnis:</h2>";
    echo "<pre>" . json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
    
    if ($result['success']) {
        echo "<p style='color: green;'>✅ API funktioniert! {$result['count']} Wheelsets geladen.</p>";
    } else {
        echo "<p style='color: red;'>❌ Fehler: " . ($result['error'] ?? 'Unbekannt') . "</p>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Exception: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}

