<?php
/**
 * Finaler Test für RESY-Integration
 */

echo "🔍 Finaler RESY-Integration Test\n";
echo "================================\n\n";

$postData = json_encode(['autohaus_id' => 1]);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://localhost/boxenstop/api/get_stored_wheelsets.php');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP-Status: $httpCode\n\n";
$data = json_decode($response, true);

if ($data) {
    echo "Erfolg: " . ($data['success'] ? "✅" : "❌") . "\n";
    if (isset($data['count'])) {
        echo "Reifensätze: " . $data['count'] . "\n";
    }
    if (isset($data['source'])) {
        echo "Quelle: " . $data['source'] . "\n";
    }
    if (isset($data['error'])) {
        echo "Fehler: " . $data['error'] . "\n";
    }
    
    if ($data['success'] && $data['count'] > 0) {
        echo "\n✅ RESY-Integration funktioniert!\n";
    } else if ($data['success'] && $data['count'] === 0) {
        echo "\n⚠️  Login erfolgreich, aber keine Daten gefunden.\n";
        echo "   Möglicherweise keine Reifensätze im System.\n";
    } else {
        echo "\n❌ Fehler bei der RESY-Integration.\n";
    }
} else {
    echo "❌ Keine gültige JSON-Response\n";
}

echo "\n✅ Test abgeschlossen!\n";

?>

