<?php
/**
 * Vollständiger RESY API Test
 * Testet alle Endpunkte und zeigt Debug-Informationen
 */

require_once 'config/database.php';
require_once 'api/resy_rest_api_complete.php';

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <title>RESY REST API - Vollständiger Test</title>
    <style>
        body { font-family: monospace; padding: 20px; background: #f5f5f5; }
        .section { background: white; padding: 20px; margin: 10px 0; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        .success { color: green; }
        .error { color: red; }
        .info { color: blue; }
        pre { background: #f8f8f8; padding: 10px; border-radius: 4px; overflow-x: auto; }
        h2 { border-bottom: 2px solid #007bff; padding-bottom: 5px; }
    </style>
</head>
<body>
    <h1>🔧 RESY REST API - Vollständiger Test</h1>
    
    <?php
    $autohausId = $_GET['autohaus_id'] ?? 1;
    echo "<p><strong>Teste mit Autohaus ID: {$autohausId}</strong></p>";
    
    try {
        $api = new ResyRestAPIComplete($autohausId);
        
        echo "<div class='section'>";
        echo "<h2>✅ API-Verbindung erfolgreich</h2>";
        echo "<p><strong>Customer No:</strong> " . htmlspecialchars($api->customerNo) . "</p>";
        echo "</div>";
        
        // Test 1: Pickup Orders
        echo "<div class='section'>";
        echo "<h2>Test 1: Pickup Orders</h2>";
        try {
            $pickupOrders = $api->getPickupOrders();
            echo "<p class='success'>✅ " . count($pickupOrders) . " Pickup Orders gefunden</p>";
            if (!empty($pickupOrders)) {
                echo "<pre>" . json_encode($pickupOrders, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
            }
        } catch (Exception $e) {
            echo "<p class='error'>❌ Fehler: " . htmlspecialchars($e->getMessage()) . "</p>";
        }
        echo "</div>";
        
        // Test 2: Inventory
        echo "<div class='section'>";
        echo "<h2>Test 2: Inventory</h2>";
        try {
            $inventory = $api->getInventory();
            echo "<p class='success'>✅ " . count($inventory) . " Inventory Items gefunden</p>";
            if (!empty($inventory)) {
                echo "<pre>" . json_encode($inventory, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
            }
        } catch (Exception $e) {
            echo "<p class='error'>❌ Fehler: " . htmlspecialchars($e->getMessage()) . "</p>";
        }
        echo "</div>";
        
        // Test 3: Wheelsets by Vehicle (Testdaten)
        echo "<div class='section'>";
        echo "<h2>Test 3: Wheelsets nach Kennzeichen (Testdaten)</h2>";
        $testPlates = ['D-ST1234', 'HH-RS9912', 'M-UH999', 'B-OO4321E'];
        foreach ($testPlates as $plate) {
            try {
                $wheelsets = $api->getWheelsetsByVehicle(null, $plate);
                if (!empty($wheelsets)) {
                    echo "<p class='success'>✅ Kennzeichen {$plate}: " . count($wheelsets) . " Wheelsets gefunden</p>";
                    echo "<pre>" . json_encode($wheelsets, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
                } else {
                    echo "<p class='info'>ℹ️ Kennzeichen {$plate}: Keine Wheelsets gefunden</p>";
                }
            } catch (Exception $e) {
                echo "<p class='error'>❌ Kennzeichen {$plate}: " . htmlspecialchars($e->getMessage()) . "</p>";
            }
        }
        echo "</div>";
        
        // Test 4: Smart Loading
        echo "<div class='section'>";
        echo "<h2>Test 4: Smart Wheelset Loading</h2>";
        try {
            $wheelsets = $api->getAllWheelsetsSmart();
            echo "<p class='success'>✅ " . count($wheelsets) . " Wheelsets gefunden (Smart Loading)</p>";
            if (!empty($wheelsets)) {
                echo "<pre>" . json_encode(array_slice($wheelsets, 0, 2), JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
                echo "<p><em>Zeige ersten 2 von " . count($wheelsets) . " Wheelsets</em></p>";
            }
        } catch (Exception $e) {
            echo "<p class='error'>❌ Fehler: " . htmlspecialchars($e->getMessage()) . "</p>";
        }
        echo "</div>";
        
        // Test 5: Customer Details
        echo "<div class='section'>";
        echo "<h2>Test 5: Customer Details</h2>";
        try {
            $customer = $api->getCustomerDetails();
            if ($customer) {
                echo "<p class='success'>✅ Customer Details geladen</p>";
                echo "<pre>" . json_encode($customer, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
            } else {
                echo "<p class='info'>ℹ️ Keine Customer Details verfügbar</p>";
            }
        } catch (Exception $e) {
            echo "<p class='error'>❌ Fehler: " . htmlspecialchars($e->getMessage()) . "</p>";
        }
        echo "</div>";
        
        // Test 6: Service Packages
        echo "<div class='section'>";
        echo "<h2>Test 6: Service Packages</h2>";
        try {
            $packages = $api->getServicePackages();
            echo "<p class='success'>✅ " . count($packages) . " Service Packages gefunden</p>";
            if (!empty($packages)) {
                echo "<pre>" . json_encode($packages, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
            }
        } catch (Exception $e) {
            echo "<p class='error'>❌ Fehler: " . htmlspecialchars($e->getMessage()) . "</p>";
        }
        echo "</div>";
        
        // Test 7: Loading Points
        echo "<div class='section'>";
        echo "<h2>Test 7: Loading Points</h2>";
        try {
            $points = $api->getLoadingPoints();
            echo "<p class='success'>✅ " . count($points) . " Loading Points gefunden</p>";
            if (!empty($points)) {
                echo "<pre>" . json_encode($points, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
            }
        } catch (Exception $e) {
            echo "<p class='error'>❌ Fehler: " . htmlspecialchars($e->getMessage()) . "</p>";
        }
        echo "</div>";
        
        // Test 8: Pickup Order Dates
        echo "<div class='section'>";
        echo "<h2>Test 8: Verfügbare Abholtermine</h2>";
        try {
            $dates = $api->getPickupOrderDates();
            echo "<p class='success'>✅ " . count($dates) . " verfügbare Termine gefunden</p>";
            if (!empty($dates)) {
                echo "<p>Nächste 5 Termine:</p>";
                echo "<pre>" . json_encode(array_slice($dates, 0, 5), JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
            }
        } catch (Exception $e) {
            echo "<p class='error'>❌ Fehler: " . htmlspecialchars($e->getMessage()) . "</p>";
        }
        echo "</div>";
        
    } catch (Exception $e) {
        echo "<div class='section'>";
        echo "<h2 class='error'>❌ KRITISCHER FEHLER</h2>";
        echo "<p class='error'>" . htmlspecialchars($e->getMessage()) . "</p>";
        echo "<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
        echo "</div>";
    }
    ?>
    
    <div class="section">
        <h2>📋 Nächste Schritte</h2>
        <ol>
            <li>Wenn alle Tests erfolgreich sind → Storage-Seite öffnen</li>
            <li>Wenn Wheelsets gefunden werden → Alles funktioniert! ✅</li>
            <li>Wenn keine Wheelsets gefunden werden → Prüfe Customer No in Datenbank</li>
        </ol>
        <p>
            <a href="admin/storage.php" style="background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 4px; display: inline-block; margin-top: 10px;">
                → Zur Storage-Seite
            </a>
        </p>
    </div>
</body>
</html>

