// Kompletter RESY-Test mit Selenium
const http = require('http');
const fs = require('fs');

// Lade Credentials von Command-Line
const username = process.argv[2] || 'D.ULUDAG';
const password = process.argv[3] || 'Ikizler123!';
const dealerId = process.argv[4] || '453';

console.log('🔐 Login mit:', username);
console.log('Dealer ID:', dealerId);
console.log('='.repeat(60) + '\n');
console.log('='.repeat(60) + '\n');

let sessionId;

// 1. Session erstellen
console.log('[1/7] Erstelle Selenium-Session...');
createSession();

function createSession() {
    const body = JSON.stringify({
        capabilities: {
            alwaysMatch: {
                browserName: 'chrome',
                'goog:chromeOptions': {
                    args: ['--no-sandbox', '--disable-dev-shm-usage']
                }
            }
        }
    });
    
    const req = http.request({
        hostname: 'localhost',
        port: 4444,
        path: '/wd/hub/session',
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'Content-Length': body.length
        }
    }, (res) => {
        let data = '';
        res.on('data', chunk => data += chunk);
        res.on('end', () => {
            sessionId = JSON.parse(data).value.sessionId;
            console.log('✅ Session:', sessionId);
            console.log('\n[2/6] Navigiere zur Login-Seite...');
            navigate();
        });
    });
    
    req.write(body);
    req.end();
}

function navigate() {
    const body = JSON.stringify({
        url: 'https://resy.dtm-reifen.de/index.php?m=login&a=login'
    });
    
    const req = http.request({
        hostname: 'localhost',
        port: 4444,
        path: `/wd/hub/session/${sessionId}/url`,
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'Content-Length': body.length
        }
    }, (res) => {
        res.on('end', () => {
            console.log('✅ Navigation erfolgreich');
            console.log('\n[3/6] Warte 3 Sekunden...');
            setTimeout(() => fillUsername(), 3000);
        });
    });
    
    req.write(body);
    req.end();
}

function fillUsername() {
    console.log('✅ Fülle Username ein...');
    
    const body = JSON.stringify({
        using: 'id',
        value: 'InputUser'
    });
    
    const req = http.request({
        hostname: 'localhost',
        port: 4444,
        path: `/wd/hub/session/${sessionId}/element`,
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'Content-Length': body.length
        }
    }, (res) => {
        let data = '';
        res.on('data', chunk => data += chunk);
        res.on('end', () => {
            const elementId = JSON.parse(data).value.ELEMENT;
            sendKeys(elementId, username, 'Username');
        });
    });
    
    req.write(body);
    req.end();
}

function sendKeys(elementId, text, label) {
    const body = JSON.stringify({
        text: text
    });
    
    const req = http.request({
        hostname: 'localhost',
        port: 4444,
        path: `/wd/hub/session/${sessionId}/element/${elementId}/value`,
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'Content-Length': body.length
        }
    }, (res) => {
        res.on('end', () => {
            console.log(`✅ ${label} eingegeben`);
            
            if (label === 'Username') {
                console.log('\n[4/6] Fülle Password ein...');
                setTimeout(() => fillPassword(), 1000);
            } else {
                console.log('\n[5/6] Klicke Login-Button...');
                setTimeout(() => clickLogin(), 1000);
            }
        });
    });
    
    req.write(body);
    req.end();
}

function fillPassword() {
    const body = JSON.stringify({
        using: 'id',
        value: 'InputPass'
    });
    
    const req = http.request({
        hostname: 'localhost',
        port: 4444,
        path: `/wd/hub/session/${sessionId}/element`,
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'Content-Length': body.length
        }
    }, (res) => {
        let data = '';
        res.on('data', chunk => data += chunk);
        res.on('end', () => {
            const elementId = JSON.parse(data).value.ELEMENT;
            sendKeys(elementId, password, 'Password');
        });
    });
    
    req.write(body);
    req.end();
}

function clickLogin() {
    const body = JSON.stringify({
        using: 'name',
        value: 'button'
    });
    
    const req = http.request({
        hostname: 'localhost',
        port: 4444,
        path: `/wd/hub/session/${sessionId}/element`,
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'Content-Length': body.length
        }
    }, (res) => {
        let data = '';
        res.on('data', chunk => data += chunk);
        res.on('end', () => {
            const elementId = JSON.parse(data).value.ELEMENT;
            
            const req2 = http.request({
                hostname: 'localhost',
                port: 4444,
                path: `/wd/hub/session/${sessionId}/element/${elementId}/click`,
                method: 'POST',
                headers: { 'Content-Type': 'application/json' }
            }, (res2) => {
                res2.on('end', () => {
                    console.log('✅ Login-Button geklickt');
                    console.log('\n[6/6] Warte 5 Sekunden und hole Page-Source...');
                    setTimeout(() => getSource(), 5000);
                });
            });
            
            req2.end();
        });
    });
    
    req.write(body);
    req.end();
}

function getSource() {
    const req = http.request({
        hostname: 'localhost',
        port: 4444,
        path: `/wd/hub/session/${sessionId}/source`,
        method: 'GET'
    }, (res) => {
        let data = '';
        res.on('data', chunk => data += chunk);
        res.on('end', () => {
            const html = JSON.parse(data).value;
            console.log('✅ Page-Source erhalten: ' + html.length + ' Zeichen');
            
            // Parse HTML nach Kennzeichen
            console.log('\n[7/7] Parse HTML...');
            const wheelsets = parseWheelsets(html);
            
            const result = {
                success: true,
                count: wheelsets.length,
                wheelsets: wheelsets
            };
            
            console.log(JSON.stringify(result));
            
            // Session beenden
            endSession();
        });
    });
    
    req.end();
}

function parseWheelsets(html) {
    const wheelsets = [];
    const rows = html.match(/<tr[^>]*>.*?<\/tr>/gs);
    
    if (rows) {
        rows.forEach((row, i) => {
            if (i === 0) return; // Überspringe Header
            
            const cells = row.match(/<td[^>]*>(.*?)<\/td>/g);
            if (cells && cells.length >= 2) {
                const kennzeichen = cells[0].match(/>([^<]+)</);
                const satznummer = cells[1].match(/>([^<]+)</);
                
                if (kennzeichen && kennzeichen[1].trim().length >= 2) {
                    wheelsets.push({
                        kennzeichen: kennzeichen[1].trim(),
                        satznummer: satznummer ? satznummer[1].trim() : '',
                        marke: 'RESY',
                        modell: '',
                        oe_nummer: satznummer ? satznummer[1].trim() : ''
                    });
                }
            }
        });
    }
    
    return wheelsets;
}

function endSession() {
    const req = http.request({
        hostname: 'localhost',
        port: 4444,
        path: `/wd/hub/session/${sessionId}`,
        method: 'DELETE'
    }, (res) => {
        // Silently end
    });
    
    req.end();
}

