<?php
/**
 * Direkter API-Call zum Testen
 */

echo "🧪 Teste RESY API-Call...\n";
echo str_repeat("=", 60) . "\n\n";

$url = 'http://localhost/boxenstop/api/get_stored_wheelsets.php?autohaus_id=1';

echo "URL: $url\n";
echo "Starte Request...\n\n";

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 180); // 3 Minuten
curl_setopt($ch, CURLOPT_VERBOSE, true);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: $httpCode\n\n";

$data = json_decode($response, true);

if ($data && isset($data['wheelsets'])) {
    echo "✅ ERFOLG!\n";
    echo "Reifensätze: " . count($data['wheelsets']) . "\n";
    echo "Source: " . $data['source'] . "\n";
    echo "Fetched from RESY: " . ($data['fetched_from_resy'] ? 'JA' : 'NEIN') . "\n\n";
    
    if (count($data['wheelsets']) > 0) {
        echo "Erste 3:\n";
        foreach (array_slice($data['wheelsets'], 0, 3) as $i => $ws) {
            echo "  " . ($i+1) . ". " . ($ws['kennzeichen'] ?? 'N/A') . "\n";
        }
    }
} else {
    echo "❌ FEHLER\n";
    echo "Response: " . substr($response, 0, 500) . "\n";
}

echo "\n" . str_repeat("=", 60) . "\n";

